/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.catalog;

import io.openshift.booster.CopyFileVisitor;
import io.openshift.booster.Files;
import io.openshift.booster.catalog.Booster;
import io.openshift.booster.catalog.Mission;
import io.openshift.booster.catalog.Runtime;
import io.openshift.booster.catalog.Version;
import io.openshift.booster.catalog.YamlConstructor;
import io.openshift.booster.catalog.spi.BoosterCatalogPathProvider;
import io.openshift.booster.catalog.spi.GitBoosterCatalogPathProvider;
import io.openshift.booster.catalog.spi.LocalBoosterCatalogPathProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class BoosterCatalogService {
    private static final String CLONED_BOOSTERS_DIR = ".boosters";
    private static final String METADATA_FILE = "metadata.json";
    private static final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor());
    public static final List<String> EXCLUDED_PROJECT_FILES = Collections.unmodifiableList(Arrays.asList(".git", ".travis", ".travis.yml", ".ds_store", ".obsidian", ".gitmodules"));
    private static final Logger logger = Logger.getLogger(BoosterCatalogService.class.getName());
    private final ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private volatile List<Booster> boosters = Collections.emptyList();
    private final BoosterCatalogPathProvider provider;

    private BoosterCatalogService(BoosterCatalogPathProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path index() {
        ReentrantReadWriteLock.WriteLock lock = this.reentrantLock.writeLock();
        Path catalogPath = null;
        try {
            lock.lock();
            catalogPath = this.provider.createCatalogPath();
            this.boosters = this.indexBoosters(catalogPath);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while indexing", e);
        }
        finally {
            logger.info(() -> "Finished content indexing");
            lock.unlock();
        }
        return catalogPath;
    }

    private List<Booster> indexBoosters(final Path catalogPath) throws IOException {
        final Path moduleRoot = catalogPath.resolve(CLONED_BOOSTERS_DIR);
        Path metadataFile = catalogPath.resolve(METADATA_FILE);
        final ArrayList<Booster> boosters = new ArrayList<Booster>();
        final HashMap<String, Mission> missions = new HashMap<String, Mission>();
        final HashMap<String, Runtime> runtimes = new HashMap<String, Runtime>();
        final HashMap versions = new HashMap();
        if (java.nio.file.Files.exists(metadataFile, new LinkOption[0])) {
            this.processMetadata(metadataFile, missions, runtimes);
        }
        java.nio.file.Files.walkFileTree(catalogPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Thread.interrupted()) {
                    return FileVisitResult.TERMINATE;
                }
                File ioFile = file.toFile();
                String fileName = ioFile.getName().toLowerCase();
                if (!fileName.startsWith(".") && (fileName.endsWith(".yaml") || fileName.endsWith(".yml"))) {
                    String id = Files.removeFileExtension(fileName);
                    Path modulePath = moduleRoot.resolve(id);
                    BoosterCatalogService.this.indexBooster(id, catalogPath, file, modulePath, missions, runtimes, versions).ifPresent(boosters::add);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (Thread.interrupted()) {
                    return FileVisitResult.TERMINATE;
                }
                return dir.startsWith(moduleRoot) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }
        });
        boosters.sort(Comparator.comparing(Booster::getName));
        return Collections.unmodifiableList(boosters);
    }

    void processMetadata(Path metadataFile, Map<String, Mission> missions, Map<String, Runtime> runtimes) {
        logger.info(() -> "Reading metadata at " + metadataFile + " ...");
        try (BufferedReader reader = java.nio.file.Files.newBufferedReader(metadataFile);
             JsonReader jsonReader = Json.createReader((Reader)reader);){
            JsonObject index = jsonReader.readObject();
            index.getJsonArray("missions").stream().map(JsonObject.class::cast).map(e -> new Mission(e.getString("id"), e.getString("name"))).forEach(m -> missions.put(m.getId(), (Mission)m));
            index.getJsonArray("runtimes").stream().map(JsonObject.class::cast).map(e -> new Runtime(e.getString("id"), e.getString("name"))).forEach(r -> runtimes.put(r.getId(), (Runtime)r));
        }
        catch (IOException e2) {
            logger.log(Level.SEVERE, "Error while processing metadata " + metadataFile, e2);
        }
    }

    private Optional<Booster> indexBooster(String id, Path catalogPath, Path file, Path moduleDir, Map<String, Mission> missions, Map<String, Runtime> runtimes, Map<String, Version> versions) {
        logger.info(() -> "Indexing " + file + " ...");
        Booster booster = null;
        try (BufferedReader reader = java.nio.file.Files.newBufferedReader(file);){
            booster = (Booster)yaml.loadAs((Reader)reader, Booster.class);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while reading " + file, e);
        }
        if (booster != null) {
            try {
                String missionId;
                String runtimeId;
                String versionId;
                booster.setId(id);
                if (file.getParent().getParent().getParent().equals(catalogPath)) {
                    versionId = null;
                    runtimeId = file.getParent().toFile().getName();
                    missionId = file.getParent().getParent().toFile().getName();
                } else {
                    versionId = file.getParent().toFile().getName();
                    runtimeId = file.getParent().getParent().toFile().getName();
                    missionId = file.getParent().getParent().getParent().toFile().getName();
                }
                booster.setMission(missions.computeIfAbsent(missionId, Mission::new));
                booster.setRuntime(runtimes.computeIfAbsent(runtimeId, Runtime::new));
                if (versionId != null) {
                    booster.setVersion(versions.computeIfAbsent(versionId, Version::new));
                }
                booster.setContentPath(moduleDir);
                if (java.nio.file.Files.notExists(moduleDir, new LinkOption[0])) {
                    moduleDir = this.provider.createBoosterContentPath(booster);
                }
                Path metadataPath = moduleDir.resolve(booster.getBoosterDescriptorPath());
                try (BufferedReader metadataReader = java.nio.file.Files.newBufferedReader(metadataPath);){
                    List vlist;
                    Map metadata = (Map)yaml.loadAs((Reader)metadataReader, Map.class);
                    booster.setMetadata(metadata);
                    if (versionId != null && (vlist = (List)metadata.get("versions")) != null) {
                        Booster b = booster;
                        vlist.stream().map(m -> new Version(Objects.toString(m.get("id")), Objects.toString(m.get("name")))).filter(v -> b.getVersion().getId().equals(v.getId())).forEach(v -> b.setVersion((Version)v));
                    }
                }
                Path descriptionPath = moduleDir.resolve(booster.getBoosterDescriptionPath());
                if (java.nio.file.Files.exists(descriptionPath, new LinkOption[0])) {
                    byte[] descriptionContent = java.nio.file.Files.readAllBytes(descriptionPath);
                    booster.setDescription(new String(descriptionContent));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while reading metadata from " + file, e);
            }
        }
        return Optional.ofNullable(booster);
    }

    public Path copy(Booster booster, Path projectRoot) throws IOException {
        Path modulePath = booster.getContentPath();
        return java.nio.file.Files.walkFileTree(modulePath, new CopyFileVisitor(projectRoot, p -> !EXCLUDED_PROJECT_FILES.contains(p.toFile().getName().toLowerCase())));
    }

    public Set<Mission> getMissions() {
        return this.boosters.stream().map(Booster::getMission).collect(Collectors.toCollection(TreeSet::new));
    }

    public Set<Runtime> getRuntimes(Mission mission) {
        if (mission == null) {
            return Collections.emptySet();
        }
        return this.boosters.stream().filter(b -> mission.equals(b.getMission())).map(Booster::getRuntime).collect(Collectors.toCollection(TreeSet::new));
    }

    public Set<Version> getVersions(Mission mission, Runtime runtime) {
        if (mission == null || runtime == null) {
            return Collections.emptySet();
        }
        return this.boosters.stream().filter(b -> mission.equals(b.getMission())).filter(b -> runtime.equals(b.getRuntime())).filter(b -> b.getVersion() != null).map(Booster::getVersion).collect(Collectors.toCollection(TreeSet::new));
    }

    public Optional<Booster> getBooster(Mission mission, Runtime runtime) {
        return this.getBooster(mission, runtime, null);
    }

    public Optional<Booster> getBooster(Mission mission, Runtime runtime, Version version) {
        Objects.requireNonNull(mission, "Mission should not be null");
        Objects.requireNonNull(runtime, "Runtime should not be null");
        return this.boosters.stream().filter(b -> mission.equals(b.getMission())).filter(b -> runtime.equals(b.getRuntime())).filter(b -> version == null || version.equals(b.getVersion())).findFirst();
    }

    public List<Booster> getBoosters() {
        ReentrantReadWriteLock.ReadLock readLock = this.reentrantLock.readLock();
        try {
            readLock.lock();
            List<Booster> list = this.boosters;
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public static class Builder {
        private String catalogRepositoryURI = "https://github.com/openshiftio/booster-catalog.git";
        private String catalogRef = "master";
        private Path rootDir;
        private BoosterCatalogPathProvider pathProvider;

        public Builder catalogRef(String catalogRef) {
            this.catalogRef = catalogRef;
            return this;
        }

        public Builder catalogRepository(String catalogRepositoryURI) {
            this.catalogRepositoryURI = catalogRepositoryURI;
            return this;
        }

        public Builder pathProvider(BoosterCatalogPathProvider pathProvider) {
            this.pathProvider = pathProvider;
            return this;
        }

        public Builder rootDir(Path root) {
            this.rootDir = root;
            return this;
        }

        public BoosterCatalogService build() {
            assert (this.catalogRef != null) : "Catalog Ref is required";
            BoosterCatalogPathProvider provider = this.pathProvider;
            if (provider == null) {
                provider = this.discoverCatalogProvider();
            }
            assert (provider != null) : "BoosterCatalogPathProvider implementation is required";
            logger.info("Using " + provider.getClass().getName());
            return new BoosterCatalogService(provider);
        }

        private BoosterCatalogPathProvider discoverCatalogProvider() {
            URL resource;
            boolean ignoreLocalZip;
            boolean bl = ignoreLocalZip = Boolean.getBoolean("BOOSTER_CATALOG_IGNORE_LOCAL") || Boolean.parseBoolean(System.getenv("BOOSTER_CATALOG_IGNORE_LOCAL"));
            BoosterCatalogPathProvider provider = ignoreLocalZip ? new GitBoosterCatalogPathProvider(this.catalogRepositoryURI, this.catalogRef, this.rootDir) : ((resource = this.getClass().getClassLoader().getResource(String.format("/booster-catalog-%s.zip", this.catalogRef))) != null ? new LocalBoosterCatalogPathProvider(resource) : new GitBoosterCatalogPathProvider(this.catalogRepositoryURI, this.catalogRef, this.rootDir));
            return provider;
        }
    }
}

