/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster.catalog;

import io.openshift.booster.catalog.Mission;
import io.openshift.booster.catalog.Runtime;
import io.openshift.booster.catalog.Version;
import java.beans.Transient;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Booster {
    private String id;
    private String githubRepo;
    private String gitRef;
    private String buildProfile;
    private String description = "No description available";
    private String boosterDescriptorPath = ".openshiftio/booster.yaml";
    private Mission mission;
    private Runtime runtime;
    private Version version;
    private Path contentPath;
    private Map<String, Object> metadata = Collections.emptyMap();

    public String getName() {
        return Objects.toString(this.getMetadata().get("name"), this.getId());
    }

    public String getDescription() {
        return Objects.toString(this.getMetadata().get("description"), this.description);
    }

    public String getBoosterDescriptionPath() {
        return Objects.toString(this.getMetadata().get("descriptionPath"), ".openshiftio/description.adoc");
    }

    public String getId() {
        return this.id;
    }

    public String getGithubRepo() {
        return this.githubRepo;
    }

    public String getGitRef() {
        return this.gitRef;
    }

    public String getBuildProfile() {
        return this.buildProfile;
    }

    @Transient
    public String getBoosterDescriptorPath() {
        return this.boosterDescriptorPath;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGithubRepo(String githubRepo) {
        this.githubRepo = githubRepo;
    }

    public void setGitRef(String gitRef) {
        this.gitRef = gitRef;
    }

    public void setBuildProfile(String buildProfile) {
        this.buildProfile = buildProfile;
    }

    public void setBoosterDescriptorPath(String boosterDescriptorPath) {
        this.boosterDescriptorPath = boosterDescriptorPath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Mission getMission() {
        return this.mission;
    }

    public void setMission(Mission mission) {
        this.mission = mission;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Transient
    public Path getContentPath() {
        return this.contentPath;
    }

    public void setContentPath(Path contentPath) {
        this.contentPath = contentPath;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildProfile == null ? 0 : this.buildProfile.hashCode());
        result = 31 * result + (this.gitRef == null ? 0 : this.gitRef.hashCode());
        result = 31 * result + (this.githubRepo == null ? 0 : this.githubRepo.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.boosterDescriptorPath == null ? 0 : this.boosterDescriptorPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Booster other = (Booster)obj;
        if (this.buildProfile == null ? other.buildProfile != null : !this.buildProfile.equals(other.buildProfile)) {
            return false;
        }
        if (this.gitRef == null ? other.gitRef != null : !this.gitRef.equals(other.gitRef)) {
            return false;
        }
        if (this.githubRepo == null ? other.githubRepo != null : !this.githubRepo.equals(other.githubRepo)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.boosterDescriptorPath == null ? other.boosterDescriptorPath != null : !this.boosterDescriptorPath.equals(other.boosterDescriptorPath));
    }

    public String toString() {
        return "Booster [githubRepo=" + this.githubRepo + ", gitRef=" + this.gitRef + ", buildProfile=" + this.buildProfile + ", obsidianDescriptorPath=" + this.boosterDescriptorPath + ", metadata=" + this.metadata + ", getName()=" + this.getName() + ", getDescription()=" + this.getDescription() + "]";
    }
}

