/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster;

import io.openshift.booster.catalog.BoosterCatalogService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Files {
    public static String removeFileExtension(String file) {
        int idx = file.lastIndexOf(46);
        return idx > 0 ? file.substring(0, idx) : file;
    }

    public static void zip(final String root, final Path directory, OutputStream os) throws IOException {
        try (final ZipOutputStream zos = new ZipOutputStream(os);){
            java.nio.file.Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (BoosterCatalogService.EXCLUDED_PROJECT_FILES.contains(file.toFile().getName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    String entry = root + File.separator + directory.relativize(file).toString();
                    zos.putNextEntry(new ZipEntry(entry));
                    java.nio.file.Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (BoosterCatalogService.EXCLUDED_PROJECT_FILES.contains(dir.toFile().getName())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    String entry = root + File.separator + directory.relativize(dir).toString() + File.separator;
                    zos.putNextEntry(new ZipEntry(entry));
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unzip(Path zipFile, Path targetDir) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(java.nio.file.Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                Path newEntry = Paths.get(targetDir.toString(), ze.getName());
                if (ze.isDirectory()) {
                    java.nio.file.Files.createDirectories(newEntry, new FileAttribute[0]);
                } else {
                    try (OutputStream os = java.nio.file.Files.newOutputStream(newEntry, new OpenOption[0]);){
                        int size;
                        byte[] buffer = new byte[512];
                        while ((size = zin.read(buffer, 0, buffer.length)) != -1) {
                            os.write(buffer, 0, size);
                        }
                    }
                }
                zin.closeEntry();
            }
        }
    }

    public static void deleteRecursively(Path path) throws IOException {
        if (java.nio.file.Files.isDirectory(path, new LinkOption[0])) {
            java.nio.file.Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    java.nio.file.Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    java.nio.file.Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            java.nio.file.Files.deleteIfExists(path);
        }
    }
}

