/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.test;

import groovy.transform.Trait;
import java.util.List;
import java.util.Map;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.ws.rs.core.UriBuilder;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.codehaus.groovy.transform.trait.Traits;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.representations.AccessTokenResponse;
import org.openremote.container.Container;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.gateway.GatewayConnection;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.security.User;

@Trait
public interface ContainerTrait {
    @Traits.Implemented
    public Container startContainer(Map<String, String> var1, Iterable<ContainerService> var2);

    @Traits.Implemented
    public boolean noEventProcessedIn(AssetProcessingService var1, int var2);

    @Traits.Implemented
    public List<Ruleset> getRulesets(Class<? extends Ruleset> var1);

    @Traits.Implemented
    public List<RealmRuleset> getRealmRulesets();

    @Traits.Implemented
    public List<AssetRuleset> getAssetRulesets();

    @Traits.Implemented
    public List<Asset> getAssets();

    @Traits.Implemented
    public List<UserAssetLink> getUserAssets();

    @Traits.Implemented
    public List<GatewayConnection> getGatewayConnections();

    @Traits.Implemented
    public List<User> getUsers();

    @Traits.Implemented
    public Container getContainer();

    @Traits.Implemented
    public int getServerPort();

    @Traits.Implemented
    public boolean isContainerRunning();

    @Traits.Implemented
    public ResteasyClientBuilder createClient();

    @Traits.Implemented
    public UriBuilder serverUri(int var1);

    @Traits.Implemented
    public void stopContainer();

    @Traits.Implemented
    public ResteasyWebTarget getClientTarget(UriBuilder var1, String var2);

    @Traits.Implemented
    public ResteasyWebTarget getClientApiTarget(UriBuilder var1, String var2);

    @Traits.Implemented
    public ResteasyWebTarget getClientApiTarget(UriBuilder var1, String var2, String var3);

    @Traits.Implemented
    public ResteasyWebTarget getClientApiTarget(UriBuilder var1, String var2, String var3, String var4);

    @Traits.Implemented
    public ResteasyWebTarget getClientApiTarget(ResteasyClient var1, UriBuilder var2, String var3, String var4);

    @Traits.Implemented
    public ResteasyWebTarget getClientApiTarget(ResteasyClient var1, UriBuilder var2, String var3, String var4, String var5);

    @Traits.Implemented
    public int findEphemeralPort();

    @Traits.Implemented
    public AccessTokenResponse authenticate(Container var1, String var2, String var3, String var4, String var5);

    @Traits.Implemented
    public ProducerTemplate getMessageProducerTemplate(Container var1);

    @Traits.Implemented
    public void addRoutes(RouteBuilder var1);

    @Traits.Implemented
    public WebSocketContainer createWebsocketClient();

    @Traits.Implemented
    public UriBuilder getWebsocketServerUrl(UriBuilder var1, String var2, String var3, String var4);

    @Traits.Implemented
    public Session connect(WebSocketContainer var1, Endpoint var2, UriBuilder var3, String var4, String var5, String var6);
}

