/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.xml;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openremote.container.xml.CatalogResourceResolver;
import org.openremote.container.xml.DOM;
import org.openremote.container.xml.ParserException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAXParser {
    private static final Logger LOG = Logger.getLogger(SAXParser.class.getName());
    private final XMLReader xr = this.create();

    public SAXParser() {
        this(null);
    }

    public SAXParser(DefaultHandler handler) {
        if (handler != null) {
            this.xr.setContentHandler(handler);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.xr.setContentHandler(handler);
    }

    protected XMLReader create() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (this.getSchemaSources() != null) {
                factory.setNamespaceAware(true);
                factory.setSchema(this.createSchema(this.getSchemaSources()));
            }
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            xmlReader.setErrorHandler(this.getErrorHandler());
            return xmlReader;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Schema createSchema(Source[] schemaSources) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new CatalogResourceResolver((Map<URI, URL>)new HashMap<URI, URL>(){
                {
                    this.put(DOM.XML_SCHEMA_NAMESPACE, DOM.XML_SCHEMA_RESOURCE);
                }
            }));
            return schemaFactory.newSchema(schemaSources);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Source[] getSchemaSources() {
        return null;
    }

    protected ErrorHandler getErrorHandler() {
        return new SimpleErrorHandler();
    }

    public void parse(InputSource source) throws ParserException {
        try {
            this.xr.parse(source);
        }
        catch (Exception ex) {
            throw new ParserException(ex);
        }
    }

    public class SimpleErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }
    }

    public static class Handler<I>
    extends DefaultHandler {
        protected SAXParser parser;
        protected I instance;
        protected Handler<?> parent;
        protected StringBuilder characters = new StringBuilder();
        protected Attributes attributes;

        public Handler(I instance) {
            this(instance, null, null);
        }

        public Handler(I instance, SAXParser parser) {
            this(instance, parser, null);
        }

        public Handler(I instance, Handler<?> parent) {
            this(instance, parent.getParser(), parent);
        }

        public Handler(I instance, SAXParser parser, Handler<?> parent) {
            this.instance = instance;
            this.parser = parser;
            this.parent = parent;
            if (parser != null) {
                parser.setContentHandler(this);
            }
        }

        public I getInstance() {
            return this.instance;
        }

        public SAXParser getParser() {
            return this.parser;
        }

        public Handler<?> getParent() {
            return this.parent;
        }

        protected void switchToParent() {
            if (this.parser != null && this.parent != null) {
                this.parser.setContentHandler(this.parent);
                this.attributes = null;
            }
        }

        public String getCharacters() {
            return this.characters.toString();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = new StringBuilder();
            this.attributes = new AttributesImpl(attributes);
            LOG.fine(this.getClass().getSimpleName() + " starting: " + localName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.characters.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isLastElement(uri, localName, qName)) {
                LOG.fine(this.getClass().getSimpleName() + ": last element, switching to parent: " + localName);
                this.switchToParent();
                return;
            }
            LOG.fine(this.getClass().getSimpleName() + " ending: " + localName);
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            return false;
        }

        protected Attributes getAttributes() {
            return this.attributes;
        }
    }
}

