/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.Session;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.openremote.container.web.socket.WebsocketEndpoint;

public class WebsocketProducer
extends DefaultProducer {
    private static final Logger LOG = Logger.getLogger(WebsocketProducer.class.getName());
    private final Boolean sendToAll;
    private final WebsocketEndpoint endpoint;

    public WebsocketProducer(WebsocketEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.sendToAll = endpoint.getSendToAll();
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object message = in.getMandatoryBody();
        if (message != null && !(message instanceof String) && !(message instanceof byte[])) {
            message = in.getMandatoryBody(String.class);
        }
        if (this.isSendToAllSet(in)) {
            this.sendToAll(message, exchange);
        } else {
            String sessionKey = (String)in.getHeader("connection.sessionKey", String.class);
            if (sessionKey != null) {
                Session websocket = this.getEndpoint().getComponent().getWebsocketSessions().get(sessionKey);
                this.sendMessage(websocket, message);
            } else {
                throw new IllegalArgumentException("Failed to send message to Websocket session; session key not set.");
            }
        }
    }

    public WebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    protected boolean isSendToAllSet(Message in) {
        Boolean value = (Boolean)in.getHeader("connection.sendToAll", (Object)this.sendToAll, Boolean.class);
        return value == null ? false : value;
    }

    protected void sendToAll(Object message, Exchange exchange) throws Exception {
        Collection<Session> sessions = this.getEndpoint().getComponent().getWebsocketSessions().getAll();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending to all sessions (" + sessions.size() + "): " + message);
        }
        CamelExchangeException exception = null;
        for (Session session : sessions) {
            try {
                this.sendMessage(session, message);
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = new CamelExchangeException("Failed to deliver message to one or more recipients.", exchange, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void sendMessage(Session session, Object message) throws IOException {
        if (session != null && session.isOpen() && message instanceof String) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.finer("Sending to session " + session.getId() + ": " + message);
            }
            session.getBasicRemote().sendText((String)message);
        }
    }
}

