/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.openremote.container.web.socket.WebsocketComponent;
import org.openremote.container.web.socket.WebsocketConsumer;
import org.openremote.container.web.socket.WebsocketProducer;
import org.openremote.container.web.socket.WebsocketSessions;

@UriEndpoint(scheme="ws", title="Undertow Websocket", syntax="ws:resourceUri", consumerClass=WebsocketConsumer.class, label="http,websocket")
public class WebsocketEndpoint
extends DefaultEndpoint {
    private WebsocketComponent component;
    @UriPath
    @Metadata(required="true")
    private String resourceUri;
    @UriParam
    private Boolean sendToAll;

    public WebsocketEndpoint(WebsocketComponent component, String uri, String resourceUri, Map<String, Object> parameters) {
        super(uri, (Component)component);
        this.resourceUri = resourceUri;
        this.component = component;
    }

    public WebsocketComponent getComponent() {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        return (WebsocketComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)((Object)this.component), (String)"component");
        WebsocketConsumer consumer = new WebsocketConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        return new WebsocketProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    public WebsocketSessions getWebsocketSessions() {
        return this.getComponent().getWebsocketSessions();
    }

    public void connect(WebsocketConsumer consumer) throws Exception {
        this.component.connect(consumer);
    }

    public void disconnect(WebsocketConsumer consumer) throws Exception {
        this.component.disconnect(consumer);
    }

    public Boolean getSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(Boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

