/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.openremote.container.web.socket.WebsocketEndpoint;

public class WebsocketConsumer
extends DefaultConsumer {
    private final WebsocketEndpoint endpoint;

    public WebsocketConsumer(WebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.endpoint.connect(this);
    }

    public void doStop() throws Exception {
        this.endpoint.disconnect(this);
        super.doStop();
    }

    public WebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void sendMessage(String message) {
        this.sendMessage((Object)message);
    }

    public void sendMessage(Object message) {
        this.sendMessage(message, null);
    }

    public void sendMessage(Object message, Consumer<Exchange> exchangePreparer) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(message);
        if (exchangePreparer != null) {
            exchangePreparer.accept(exchange);
        }
        this.getAsyncProcessor().process(exchange, doneSync -> {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        });
    }
}

