/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ServiceHelper;
import org.openremote.container.web.socket.MemoryWebsocketSessions;
import org.openremote.container.web.socket.WebsocketConsumer;
import org.openremote.container.web.socket.WebsocketEndpoint;
import org.openremote.container.web.socket.WebsocketSessions;

public abstract class WebsocketComponent
extends DefaultComponent {
    private static final Logger LOG = Logger.getLogger(WebsocketComponent.class.getName());
    public static final String NAME = "websocket";
    protected final Map<String, WebsocketConsumer> consumers = new HashMap<String, WebsocketConsumer>();
    protected final WebsocketSessions websocketSessions = new MemoryWebsocketSessions();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WebsocketEndpoint endpoint = new WebsocketEndpoint(this, uri, remaining, parameters);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.getWebsocketSessions());
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object)this.getWebsocketSessions());
        this.undeploy();
    }

    public WebsocketSessions getWebsocketSessions() {
        return this.websocketSessions;
    }

    public Map<String, WebsocketConsumer> getConsumers() {
        return this.consumers;
    }

    public synchronized void connect(WebsocketConsumer consumer) {
        String resourceUri = consumer.getEndpoint().getResourceUri();
        if (this.consumers.containsKey(resourceUri)) {
            LOG.fine("Websocket server endpoint already connected: " + resourceUri);
            return;
        }
        this.consumers.put(resourceUri, consumer);
        try {
            this.redeploy();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void disconnect(WebsocketConsumer consumer) {
        String resourceUri = consumer.getEndpoint().getResourceUri();
        if (!this.consumers.containsKey(resourceUri)) {
            return;
        }
        this.consumers.remove(resourceUri);
        try {
            this.redeploy(this.consumers.size() == 0);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void redeploy() throws Exception {
        this.redeploy(false);
    }

    protected void redeploy(boolean doUndeployOnly) throws Exception {
        this.undeploy();
        if (!doUndeployOnly) {
            this.deploy();
        }
    }

    protected abstract void deploy() throws Exception;

    protected abstract void undeploy() throws Exception;
}

