/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebsocketCORSFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(WebsocketCORSFilter.class.getName());
    public static final String ALLOWED_ORIGIN = "ALLOWED_ORIGIN";
    protected String allowedOrigin;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.allowedOrigin = filterConfig.getInitParameter(ALLOWED_ORIGIN);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String origin;
        if (this.allowedOrigin == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No origin restriction, allowing Websocket upgrade request");
            }
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null && (origin = req.getHeader("Origin")) != null && origin.equals(this.allowedOrigin)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received origin is allowed origin, allowing Websocket upgrade request: " + origin);
            }
            chain.doFilter(request, response);
            return;
        }
        LOG.info("Illegal origin, dropping Websocket upgrade request");
        resp.sendError(400, "Origin is not allowed");
    }

    public void destroy() {
    }
}

