/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.socket;

import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.apache.camel.Exchange;
import org.openremote.container.security.AuthContext;
import org.openremote.container.web.socket.WebsocketConsumer;

public class WebsocketAdapter
extends Endpoint {
    private static final Logger LOG = Logger.getLogger(WebsocketAdapter.class.getName());
    protected final WebsocketConsumer consumer;

    public WebsocketAdapter(WebsocketConsumer consumer) {
        this.consumer = consumer;
    }

    public void onOpen(Session session, EndpointConfig config) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Websocket session open: " + session.getId());
        }
        session.setMaxIdleTimeout(0L);
        this.consumer.getEndpoint().getWebsocketSessions().add(session);
        this.consumer.sendMessage(null, exchange -> {
            this.prepareExchange((Exchange)exchange, session);
            exchange.getIn().setHeader("connection.sessionOpen", (Object)true);
        });
        session.addMessageHandler(String.class, message -> {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Websocket session " + session.getId() + " message received: " + message);
            }
            this.consumer.sendMessage(message, exchange -> this.prepareExchange((Exchange)exchange, session));
        });
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Websocket session close: " + session.getId() + " " + closeReason);
        }
        this.consumer.sendMessage(closeReason, exchange -> {
            this.prepareExchange((Exchange)exchange, session);
            exchange.getIn().setHeader("connection.sessionClose", (Object)true);
        });
        this.consumer.getEndpoint().getWebsocketSessions().remove(session);
    }

    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
        if (!(thr instanceof IOException && thr.getMessage().equals("Connection reset by peer") || !LOG.isLoggable(Level.INFO))) {
            LOG.log(Level.INFO, "Websocket session error: " + session.getId(), thr);
        }
        this.consumer.sendMessage(thr, exchange -> {
            this.prepareExchange((Exchange)exchange, session);
            exchange.getIn().setHeader("connection.sessionCloseError", (Object)true);
        });
        this.consumer.getEndpoint().getWebsocketSessions().remove(session);
    }

    protected void prepareExchange(Exchange exchange, Session session) {
        exchange.getIn().setHeader("connection.sessionKey", (Object)session.getId());
        exchange.getIn().setHeader("AUTH_CONTEXT", (Object)this.getHandshakeAuth(session));
        exchange.getIn().setHeader("Realm", (Object)this.getHandshakeRealm(session));
        exchange.getIn().setHeader("connection.sessionTerminator", (Object)this.getSessionTerminator(session));
    }

    protected AuthContext getHandshakeAuth(Session session) {
        return (AuthContext)session.getUserProperties().get("connection.auth");
    }

    protected String getHandshakeRealm(Session session) {
        return (String)session.getUserProperties().get("connection.realm");
    }

    protected Runnable getSessionTerminator(Session session) {
        return () -> {
            try {
                session.close();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (IOException ignored) {
                LOG.log(Level.INFO, "Failed to close client session: " + session.getId());
            }
        };
    }
}

