/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.file;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openremote.container.web.file.GzipHttpServletResponse;
import org.openremote.container.web.file.HttpFilter;

public class GzipResponseFilter
extends HttpFilter {
    private static final String INIT_PARAM_THRESHOLD = "threshold";
    private static final String INIT_PARAM_MIMETYPES = "mimetypes";
    private static final int DEFAULT_THRESHOLD = 150;
    private static final Set<String> DEFAULT_MIMETYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("text/plain", "text/html", "text/xml", "text/css", "text/javascript", "text/csv", "text/rtf", "application/xml", "application/xhtml+xml", "application/javascript", "application/json", "image/svg+xml")));
    private static final String ERROR_THRESHOLD = "The 'threshold' init param must be a number between 0 and 9999. Encountered an invalid value of '%s'.";
    private Set<String> mimetypes = DEFAULT_MIMETYPES;
    private int threshold = 150;

    public GzipResponseFilter() {
    }

    public GzipResponseFilter(String[] mimetypes) {
        this.mimetypes = new HashSet<String>(Arrays.asList(mimetypes));
    }

    @Override
    public void init() throws ServletException {
        String mimetypesParam;
        String thresholdParam = this.getInitParameter(INIT_PARAM_THRESHOLD);
        if (thresholdParam != null) {
            if (!thresholdParam.matches("[0-9]{1,4}")) {
                throw new ServletException(String.format(ERROR_THRESHOLD, thresholdParam));
            }
            this.threshold = Integer.valueOf(thresholdParam);
        }
        if ((mimetypesParam = this.getInitParameter(INIT_PARAM_MIMETYPES)) != null) {
            this.mimetypes = new HashSet<String>(Arrays.asList(mimetypesParam.split("\\s*,\\s*")));
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        if (GzipResponseFilter.acceptsGzip(request)) {
            GzipHttpServletResponse gzipResponse = new GzipHttpServletResponse(response, this.threshold, this.mimetypes);
            chain.doFilter((ServletRequest)request, (ServletResponse)gzipResponse);
            gzipResponse.close();
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static boolean acceptsGzip(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Accept-Encoding");
        while (e.hasMoreElements()) {
            if (!((String)e.nextElement()).contains("gzip")) continue;
            return true;
        }
        return false;
    }
}

