/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openremote.container.web.file.AbstractFileServlet;

public class FileServlet
extends AbstractFileServlet {
    private static final Logger LOG = Logger.getLogger(FileServlet.class.getName());
    public static final long DEFAULT_EXPIRE_SECONDS = 600L;
    public static final long EXPIRES_SECONDS_CACHE_JS = 1209600L;
    protected final boolean devMode;
    protected final File base;
    protected final File unsecuredIndex;
    protected final String[] requiredRoles;
    protected final Map<String, String> mimeTypes;
    protected final Map<String, Integer> mimeTypesExpireSeconds;
    protected final String[] alreadyZippedExtensions;

    public FileServlet(boolean devMode, File base, String[] requiredRoles, Map<String, String> mimeTypes, Map<String, Integer> mimeTypesExpireSeconds, String[] alreadyZippedExtensions) {
        this.devMode = devMode;
        this.base = base;
        this.unsecuredIndex = new File(base, "index.html");
        this.requiredRoles = requiredRoles;
        this.mimeTypes = mimeTypes;
        this.mimeTypesExpireSeconds = mimeTypesExpireSeconds;
        this.alreadyZippedExtensions = alreadyZippedExtensions;
    }

    public boolean isSecured() {
        return this.requiredRoles != null && this.requiredRoles.length > 0;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isSecured()) {
            if (request.authenticate(response)) {
                boolean userHasAllRoles = true;
                for (String requiredRole : this.requiredRoles) {
                    if (request.isUserInRole(requiredRole)) continue;
                    userHasAllRoles = false;
                }
                if (userHasAllRoles) {
                    LOG.fine("User has all roles to access: " + request.getPathInfo());
                    super.service(request, response);
                } else {
                    LOG.fine("User doesn't have the required roles '" + Arrays.toString(this.requiredRoles) + "' to access: " + request.getPathInfo());
                    response.sendError(403);
                }
            } else {
                response.sendError(401);
            }
        } else {
            super.service(request, response);
        }
    }

    @Override
    protected File getFile(HttpServletRequest request) throws AbstractFileServlet.RedirectException {
        File file;
        String relativePath = request.getPathInfo();
        if (relativePath == null || relativePath.isEmpty()) {
            relativePath = "";
        }
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        File actualBase = this.base;
        if (this.isSecured()) {
            String realm = request.getHeader("Realm");
            if (realm == null || realm.length() == 0) {
                LOG.fine("Ignoring request, secured service needs request header: Realm");
                return null;
            }
            actualBase = new File(this.base, realm);
            if (!actualBase.isDirectory()) {
                LOG.fine("Ignoring request, missing realm content directory: " + actualBase.getAbsolutePath());
                return null;
            }
        }
        if ((file = new File(actualBase, relativePath)).isDirectory()) {
            if (request.getPathInfo() == null || !request.getPathInfo().endsWith("/")) {
                throw new AbstractFileServlet.RedirectException(request.getRequestURI() + "/");
            }
            file = new File(actualBase, relativePath + "/index.html");
        }
        LOG.fine("Serving file: " + file.getAbsolutePath());
        return file;
    }

    @Override
    protected long getExpireTime(HttpServletRequest request, File file) {
        long expireTime = 600L;
        String contentType = this.getContentType(request, file);
        if (this.mimeTypesExpireSeconds.containsKey(contentType)) {
            expireTime = this.mimeTypesExpireSeconds.get(contentType).intValue();
        }
        expireTime = this.devMode ? 0L : expireTime;
        return expireTime;
    }

    @Override
    protected String getContentType(HttpServletRequest request, File file) {
        return FileServlet.coalesce(FileServlet.coalesce(request.getServletContext().getMimeType(file.getName()), this.mimeTypes.get(this.getExtension(file.getName()))), "application/octet-stream");
    }

    @Override
    protected String setContentHeaders(HttpServletRequest request, HttpServletResponse response, AbstractFileServlet.Resource resource, List<AbstractFileServlet.Range> ranges) {
        String result = super.setContentHeaders(request, response, resource, ranges);
        for (String alreadyZippedExtension : this.alreadyZippedExtensions) {
            if (!request.getPathInfo().endsWith(alreadyZippedExtension)) continue;
            response.addHeader("Content-Encoding", "gzip");
            break;
        }
        return result;
    }

    protected String getExtension(String fileName) {
        int i = fileName.lastIndexOf(46);
        return i > 0 ? fileName.substring(i + 1) : "";
    }
}

