/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.openremote.container.json.JacksonConfig;
import org.openremote.container.web.FollowRedirectFilter;
import org.openremote.container.web.HeaderInjectorFilter;
import org.openremote.container.web.OAuthFilter;
import org.openremote.container.web.PermanentFailureFilter;
import org.openremote.container.web.QueryParameterInjectorFilter;
import org.openremote.model.auth.OAuthGrant;

public class WebTargetBuilder {
    public static final int CONNECTION_POOL_SIZE = 10;
    public static final long CONNECTION_CHECKOUT_TIMEOUT_MILLISECONDS = 5000L;
    public static final long CONNECTION_TIMEOUT_MILLISECONDS = 10000L;
    protected ResteasyClient client;
    protected static ExecutorService executorService;
    protected BasicAuthentication basicAuthentication;
    protected OAuthGrant oAuthGrant;
    protected URI baseUri;
    protected List<Integer> failureResponses = new ArrayList<Integer>();
    protected Map<String, List<String>> injectHeaders;
    protected Map<String, List<String>> injectQueryParameters;
    protected boolean followRedirects = false;

    public WebTargetBuilder(ResteasyClient client, URI baseUri) {
        this.client = client;
        this.baseUri = baseUri;
    }

    public WebTargetBuilder setBasicAuthentication(String username, String password) {
        this.basicAuthentication = new BasicAuthentication(username, password);
        return this;
    }

    public WebTargetBuilder setOAuthAuthentication(OAuthGrant oAuthGrant) {
        this.oAuthGrant = oAuthGrant;
        return this;
    }

    public WebTargetBuilder setInjectHeaders(Map<String, List<String>> injectHeaders) {
        this.injectHeaders = injectHeaders;
        return this;
    }

    public WebTargetBuilder setInjectQueryParameters(Map<String, List<String>> injectQueryParameters) {
        this.injectQueryParameters = injectQueryParameters;
        return this;
    }

    public WebTargetBuilder addPermanentFailureResponse(Response.Status ... responseStatus) {
        Collections.addAll(this.failureResponses, (Integer[])Arrays.stream(responseStatus).map(Response.Status::getStatusCode).toArray(Integer[]::new));
        return this;
    }

    public WebTargetBuilder addPermanentFailureResponse(Integer ... responseStatus) {
        Collections.addAll(this.failureResponses, responseStatus);
        return this;
    }

    public WebTargetBuilder removePermanentFailureResponse(Response.Status ... responseStatus) {
        this.failureResponses.removeAll(Arrays.stream(responseStatus).map(Response.Status::getStatusCode).collect(Collectors.toList()));
        return this;
    }

    public WebTargetBuilder removePermanentFailureResponse(Integer ... responseStatus) {
        this.failureResponses.removeAll(Arrays.asList(responseStatus));
        return this;
    }

    public WebTargetBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public ResteasyWebTarget build() {
        ResteasyWebTarget target = this.client.target(this.baseUri);
        target.register(QueryParameterInjectorFilter.class);
        if (!this.failureResponses.isEmpty()) {
            target.register((Object)new PermanentFailureFilter(this.failureResponses), 1);
        }
        if (this.oAuthGrant != null) {
            OAuthFilter oAuthFilter = new OAuthFilter(this.client, this.oAuthGrant);
            target.register((Object)oAuthFilter, 1000);
        } else if (this.basicAuthentication != null) {
            target.register((Object)this.basicAuthentication, 1000);
        }
        if (this.injectHeaders != null) {
            target.register((Object)new HeaderInjectorFilter(this.injectHeaders));
        }
        if (this.injectQueryParameters != null) {
            target.property(QueryParameterInjectorFilter.QUERY_PARAMETERS_PROPERTY, WebTargetBuilder.mapToMultivaluedMap(this.injectQueryParameters, new MultivaluedHashMap()));
        }
        if (this.followRedirects) {
            target.register((Object)new FollowRedirectFilter());
        }
        return target;
    }

    public static ResteasyClient createClient(ExecutorService executorService) {
        return WebTargetBuilder.createClient(executorService, 10, 10000L, null);
    }

    public static ResteasyClient createClient(ExecutorService executorService, int connectionPoolSize, long overrideSocketTimeout, UnaryOperator<ResteasyClientBuilder> builderConfigurator) {
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").setConnectionRequestTimeout(Long.valueOf(5000L).intValue()).setConnectTimeout(Long.valueOf(5000L).intValue()).setSocketTimeout(Long.valueOf(overrideSocketTimeout).intValue()).build();
        CloseableHttpClient apacheClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine((HttpClient)apacheClient);
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)engine).connectionPoolSize(connectionPoolSize).connectionCheckoutTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(overrideSocketTimeout, TimeUnit.MILLISECONDS).connectTimeout(10000L, TimeUnit.MILLISECONDS).register((Object)new JacksonConfig());
        if (executorService != null) {
            clientBuilder.executorService(executorService);
        }
        if (builderConfigurator != null) {
            clientBuilder = (ResteasyClientBuilder)builderConfigurator.apply(clientBuilder);
        }
        return clientBuilder.build();
    }

    public static <K, V, W extends V> MultivaluedMap<K, V> mapToMultivaluedMap(Map<K, List<W>> map, MultivaluedMap<K, V> multivaluedMap) {
        for (Map.Entry<K, List<W>> e : map.entrySet()) {
            multivaluedMap.put(e.getKey(), (Object)(e.getValue() == null ? null : new ArrayList(e.getValue())));
        }
        return multivaluedMap;
    }
}

