/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.util.HttpString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

public class WebServiceExceptions {
    private static final Logger LOG = Logger.getLogger(WebServiceExceptions.class.getName());

    public static Response handleResteasyException(boolean devMode, String origin, Request request, UriInfo uriInfo, Throwable throwable) {
        WebServiceExceptions.logException(throwable, origin, request.getMethod() + " " + uriInfo.getRequestUri());
        int statusCode = 500;
        if (throwable instanceof WebApplicationException) {
            Response response = ((WebApplicationException)throwable).getResponse();
            switch (response.getStatusInfo().getFamily()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    statusCode = response.getStatus();
                    break;
                }
                default: {
                    return response;
                }
            }
        }
        try {
            if (devMode) {
                return Response.status((int)statusCode).entity((Object)WebServiceExceptions.renderDevModeError(statusCode, throwable)).type(MediaType.TEXT_PLAIN_TYPE).build();
            }
            return Response.status((int)statusCode).entity((Object)WebServiceExceptions.renderProductionError(statusCode, throwable)).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Couldn't render server error trace response", ex);
            return Response.serverError().build();
        }
    }

    public static void handleUndertowException(boolean devMode, String origin, boolean logOnly, HttpServerExchange exchange, Throwable throwable) {
        WebServiceExceptions.logException(throwable, origin, exchange.toString());
        if (!logOnly && exchange.isResponseChannelAvailable()) {
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)"Content-Type"), "text/plain");
            try {
                if (devMode) {
                    exchange.getResponseSender().send(WebServiceExceptions.renderDevModeError(exchange.getStatusCode(), throwable));
                } else {
                    exchange.getResponseSender().send(WebServiceExceptions.renderProductionError(exchange.getStatusCode(), throwable));
                }
            }
            catch (Exception ex2) {
                LOG.log(Level.SEVERE, "Couldn't render server error response", ex2);
            }
        }
    }

    public static String renderDevModeError(int statusCode, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        return "Request failed with HTTP error status: " + statusCode + (String)(status != null ? " " + status.getReasonPhrase() : "") + "\n\n" + sw.toString();
    }

    public static String renderProductionError(int statusCode, Throwable t) {
        Response.Status status = Response.Status.fromStatusCode((int)statusCode);
        return "Request failed with HTTP error status: " + statusCode + (String)(status != null ? " " + status.getReasonPhrase() : "") + "\n\nPlease contact the help desk.";
    }

    public static void logException(Throwable throwable, String origin, String info) {
        if ("java.io.IOException: Broken pipe".equals(WebServiceExceptions.getRootCause(throwable).toString())) {
            return;
        }
        if ("java.io.IOException: Connection reset by peer".equals(WebServiceExceptions.getRootCause(throwable).toString())) {
            return;
        }
        if (throwable instanceof WebApplicationException && ((WebApplicationException)throwable).getResponse().getStatus() == 404) {
            LOG.log(Level.FINE, "Web service exception (404) in '" + origin + "' for '" + info + "'");
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Web service exception in '" + origin + "' for '" + info + "' type = " + throwable.getClass().getSimpleName() + ", message=" + throwable.getMessage(), throwable);
        } else {
            LOG.log(Level.INFO, "Web service exception in '" + origin + "' for '" + info + "', root cause: " + WebServiceExceptions.getRootCause(throwable));
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable last;
        do {
            last = throwable;
        } while ((throwable = WebServiceExceptions.getCause(throwable)) != null);
        return last;
    }

    public static Throwable getCause(Throwable throwable) {
        if (throwable != null && throwable.getCause() != null && throwable != throwable.getCause()) {
            return throwable.getCause();
        }
        return null;
    }

    public static class ServletUndertowExceptionHandler
    implements ExceptionHandler {
        protected final boolean devMode;

        public ServletUndertowExceptionHandler(boolean devMode) {
            this.devMode = devMode;
        }

        public boolean handleThrowable(HttpServerExchange exchange, ServletRequest request, ServletResponse response, Throwable throwable) {
            if (!exchange.isResponseStarted()) {
                exchange.setStatusCode(500);
            }
            WebServiceExceptions.handleUndertowException(this.devMode, "Undertow Servlet Dispatch", response.isCommitted(), exchange, throwable);
            return true;
        }
    }

    public static class RootUndertowExceptionHandler
    implements HttpHandler {
        protected final boolean devMode;
        protected final HttpHandler nextHandler;

        public RootUndertowExceptionHandler(boolean devMode, HttpHandler nextHandler) {
            this.devMode = devMode;
            this.nextHandler = nextHandler;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                if (this.nextHandler == null) {
                    throw new IllegalStateException("This Undertow handler must wrap another handler");
                }
                this.nextHandler.handleRequest(exchange);
            }
            catch (Throwable t) {
                WebServiceExceptions.handleUndertowException(this.devMode, "Undertow Root Dispatch", false, exchange, t);
            }
        }
    }

    @Provider
    public static class ForbiddenResteasyExceptionMapper
    implements ExceptionMapper<ForbiddenException> {
        @Context
        protected Request request;
        @Context
        protected UriInfo uriInfo;
        protected final boolean devMode;

        public ForbiddenResteasyExceptionMapper(boolean devMode) {
            this.devMode = devMode;
        }

        public Response toResponse(ForbiddenException exception) {
            return WebServiceExceptions.handleResteasyException(this.devMode, "RESTEasy Role Security", this.request, this.uriInfo, (Throwable)exception);
        }
    }

    @Provider
    public static class DefaultResteasyExceptionMapper
    implements ExceptionMapper<Exception> {
        @Context
        protected Request request;
        @Context
        protected UriInfo uriInfo;
        protected final boolean devMode;

        public DefaultResteasyExceptionMapper(boolean devMode) {
            this.devMode = devMode;
        }

        public Response toResponse(Exception exception) {
            return WebServiceExceptions.handleResteasyException(this.devMode, "RESTEasy Dispatch", this.request, this.uriInfo, exception);
        }
    }
}

