/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RequestDumpingHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ExceptionHandler;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.net.Inet4Address;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.openremote.container.json.JacksonConfig;
import org.openremote.container.security.CORSFilter;
import org.openremote.container.security.IdentityService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.AlreadyGzippedWriterInterceptor;
import org.openremote.container.web.ClientErrorExceptionHandler;
import org.openremote.container.web.GZIPEncodingInterceptor;
import org.openremote.container.web.WebApplication;
import org.openremote.container.web.WebServiceExceptions;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.util.TextUtil;
import org.xnio.Options;

public abstract class WebService
implements ContainerService {
    public static final String OR_WEBSERVER_LISTEN_HOST = "OR_WEBSERVER_LISTEN_HOST";
    public static final String OR_WEBSERVER_LISTEN_HOST_DEFAULT = "0.0.0.0";
    public static final String OR_WEBSERVER_LISTEN_PORT = "OR_WEBSERVER_LISTEN_PORT";
    public static final int OR_WEBSERVER_LISTEN_PORT_DEFAULT = 8080;
    public static final String OR_WEBSERVER_DUMP_REQUESTS = "OR_WEBSERVER_DUMP_REQUESTS";
    public static final boolean OR_WEBSERVER_DUMP_REQUESTS_DEFAULT = false;
    public static final String OR_WEBSERVER_ALLOWED_ORIGINS = "OR_WEBSERVER_ALLOWED_ORIGINS";
    public static final String OR_WEBSERVER_IO_THREADS_MAX = "OR_WEBSERVER_IO_THREADS_MAX";
    public static final int OR_WEBSERVER_IO_THREADS_MAX_DEFAULT = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    public static final String OR_WEBSERVER_WORKER_THREADS_MAX = "OR_WEBSERVER_WORKER_THREADS_MAX";
    public static final int WEBSERVER_WORKER_THREADS_MAX_DEFAULT = Math.max(Runtime.getRuntime().availableProcessors(), 10);
    private static final Logger LOG = Logger.getLogger(WebService.class.getName());
    protected static AtomicReference<CORSFilter> corsFilterRef;
    protected boolean devMode;
    protected String host;
    protected int port;
    protected Undertow undertow;
    protected List<RequestHandler> httpHandlers = new ArrayList<RequestHandler>();
    protected URI containerHostUri;

    protected static String getLocalIpAddress() throws Exception {
        return Inet4Address.getLocalHost().getHostAddress();
    }

    public static RequestHandler pathStartsWithHandler(String name, String path, HttpHandler handler) {
        return new RequestHandler(name, exchange -> exchange.getRequestPath().startsWith(path), handler);
    }

    public void init(Container container) throws Exception {
        this.devMode = container.isDevMode();
        this.host = MapAccess.getString(container.getConfig(), OR_WEBSERVER_LISTEN_HOST, OR_WEBSERVER_LISTEN_HOST_DEFAULT);
        this.port = MapAccess.getInteger(container.getConfig(), OR_WEBSERVER_LISTEN_PORT, 8080);
        String containerHost = this.host.equalsIgnoreCase("localhost") || this.host.indexOf("127") == 0 || this.host.indexOf(OR_WEBSERVER_LISTEN_HOST_DEFAULT) == 0 ? WebService.getLocalIpAddress() : this.host;
        this.containerHostUri = UriBuilder.fromPath((String)"/").scheme("http").host(containerHost).port(this.port).build(new Object[0]);
        this.undertow = this.build(container, Undertow.builder().addHttpListener(this.port, this.host).setIoThreads(MapAccess.getInteger(container.getConfig(), OR_WEBSERVER_IO_THREADS_MAX, OR_WEBSERVER_IO_THREADS_MAX_DEFAULT)).setWorkerThreads(MapAccess.getInteger(container.getConfig(), OR_WEBSERVER_WORKER_THREADS_MAX, WEBSERVER_WORKER_THREADS_MAX_DEFAULT)).setWorkerOption(Options.WORKER_NAME, (Object)"WebService").setWorkerOption(Options.THREAD_DAEMON, (Object)true)).build();
    }

    public void start(Container container) throws Exception {
        if (this.undertow != null) {
            this.undertow.start();
            LOG.info("Webserver ready on http://" + this.host + ":" + this.port);
        }
    }

    public void stop(Container container) throws Exception {
        if (this.undertow != null) {
            this.undertow.stop();
            this.undertow = null;
        }
    }

    public static HttpHandler addServletDeployment(Container container, DeploymentInfo deploymentInfo, boolean secure) {
        IdentityService identityService = (IdentityService)container.getService(IdentityService.class);
        boolean devMode = container.isDevMode();
        try {
            if (secure) {
                if (identityService == null) {
                    throw new IllegalStateException("No identity service found, make sure " + IdentityService.class.getName() + " is added before this service");
                }
                identityService.secureDeployment(deploymentInfo);
            } else {
                LOG.info("Deploying insecure web context: " + deploymentInfo.getContextPath());
            }
            deploymentInfo.setExceptionHandler((ExceptionHandler)new WebServiceExceptions.ServletUndertowExceptionHandler(devMode));
            FilterInfo corsFilterInfo = WebService.getCorsFilterInfo(container);
            if (corsFilterInfo != null) {
                deploymentInfo.addFilter(corsFilterInfo);
                deploymentInfo.addFilterUrlMapping(corsFilterInfo.getName(), "*", DispatcherType.REQUEST);
                deploymentInfo.addFilterUrlMapping(corsFilterInfo.getName(), "*", DispatcherType.FORWARD);
            }
            DeploymentManager manager = Servlets.defaultContainer().addDeployment(deploymentInfo);
            manager.deploy();
            return manager.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeServletDeployment(DeploymentInfo deploymentInfo) {
        try {
            DeploymentManager manager = Servlets.defaultContainer().getDeployment(deploymentInfo.getDeploymentName());
            manager.stop();
            manager.undeploy();
            Servlets.defaultContainer().removeDeployment(deploymentInfo);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<RequestHandler> getRequestHandlers() {
        return this.httpHandlers;
    }

    public URI getHostUri() {
        return this.containerHostUri;
    }

    protected Undertow.Builder build(Container container, Undertow.Builder builder) {
        LOG.info("Building web routing with handler(s): " + this.getRequestHandlers().stream().map(h -> h.name).collect(Collectors.joining("\n")));
        HttpHandler handler = exchange -> {
            String requestPath = exchange.getRequestPath();
            LOG.fine("Handling request: " + exchange.getRequestMethod() + " " + exchange.getRequestPath());
            boolean handled = false;
            for (RequestHandler requestHandler : this.getRequestHandlers()) {
                if (!requestHandler.handlePredicate.test(exchange)) continue;
                LOG.fine("Handling '" + requestPath + "' with handler: " + requestHandler.name);
                requestHandler.handler.handleRequest(exchange);
                handled = true;
                break;
            }
            if (!handled) {
                LOG.warning("No handler found for request: " + exchange.getRequestPath());
            }
        };
        handler = new WebServiceExceptions.RootUndertowExceptionHandler(this.devMode, handler);
        if (MapAccess.getBoolean(container.getConfig(), OR_WEBSERVER_DUMP_REQUESTS, false)) {
            handler = new RequestDumpingHandler(handler);
        }
        builder.setHandler(handler);
        return builder;
    }

    protected ResteasyDeployment createResteasyDeployment(Container container, Collection<Class<?>> apiClasses, Collection<Object> apiSingletons, boolean secure) {
        if (apiClasses == null && apiSingletons == null) {
            return null;
        }
        WebApplication webApplication = new WebApplication(container, apiClasses, apiSingletons);
        ResteasyDeployment resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.setApplication((Application)webApplication);
        resteasyDeployment.getProviders().add(new WebServiceExceptions.DefaultResteasyExceptionMapper(this.devMode));
        resteasyDeployment.getProviders().add(new WebServiceExceptions.ForbiddenResteasyExceptionMapper(this.devMode));
        resteasyDeployment.getProviders().add(new JacksonConfig());
        resteasyDeployment.getProviders().add(new GZIPEncodingInterceptor(!container.isDevMode()));
        resteasyDeployment.getActualProviderClasses().add(AlreadyGzippedWriterInterceptor.class);
        resteasyDeployment.getActualProviderClasses().add(ClientErrorExceptionHandler.class);
        resteasyDeployment.setSecurityEnabled(secure);
        return resteasyDeployment;
    }

    public static synchronized FilterInfo getCorsFilterInfo(Container container) {
        if (corsFilterRef == null) {
            CORSFilter corsFilter = null;
            if (!container.isDevMode()) {
                Set<String> allowedOrigins = WebService.getAllowedOrigins(container);
                if (!allowedOrigins.isEmpty()) {
                    corsFilter = new CORSFilter();
                    corsFilter.setAllowCredentials(true);
                    corsFilter.setAllowedMethods("GET, POST, PUT, DELETE, OPTIONS, HEAD");
                    corsFilter.setExposedHeaders("*");
                    corsFilter.setCorsMaxAge(1209600);
                    corsFilter.getAllowedOrigins().addAll(allowedOrigins);
                }
            } else {
                corsFilter = new CORSFilter();
                corsFilter.getAllowedOrigins().add("*");
                corsFilter.setAllowCredentials(true);
                corsFilter.setExposedHeaders("*");
                corsFilter.setAllowedMethods("GET, POST, PUT, DELETE, OPTIONS, HEAD");
                corsFilter.setCorsMaxAge(1209600);
            }
            corsFilterRef = new AtomicReference<CORSFilter>(corsFilter);
        }
        if (corsFilterRef.get() != null) {
            CORSFilter finalCorsFilter = corsFilterRef.get();
            return Servlets.filter((String)"CORS Filter", CORSFilter.class, () -> new ImmediateInstanceHandle((Object)finalCorsFilter)).setAsyncSupported(true);
        }
        return null;
    }

    public static List<String> getExternalHostnames(Container container) {
        String defaultHostname = MapAccess.getString(container.getConfig(), "OR_HOSTNAME", null);
        String additionalHostnamesStr = MapAccess.getString(container.getConfig(), "OR_ADDITIONAL_HOSTNAMES", null);
        ArrayList<String> externalHostnames = new ArrayList<String>();
        if (!TextUtil.isNullOrEmpty((String)additionalHostnamesStr)) {
            externalHostnames.addAll(Arrays.stream(additionalHostnamesStr.split(",")).toList());
        }
        if (!TextUtil.isNullOrEmpty((String)defaultHostname) && !externalHostnames.contains(defaultHostname)) {
            externalHostnames.add(defaultHostname);
        }
        return externalHostnames;
    }

    public static Set<String> getAllowedOrigins(Container container) {
        HashSet<String> allowedOrigins = new HashSet<String>(WebService.getExternalHostnames(container).stream().map(hostname -> "https://" + hostname).toList());
        String allowedOriginsStr = MapAccess.getString(container.getConfig(), OR_WEBSERVER_ALLOWED_ORIGINS, null);
        if (!TextUtil.isNullOrEmpty((String)allowedOriginsStr)) {
            allowedOrigins.addAll(Arrays.stream(allowedOriginsStr.split(",")).toList());
        }
        return allowedOrigins;
    }

    public static class RequestHandler {
        protected String name;
        protected Predicate<HttpServerExchange> handlePredicate;
        protected HttpHandler handler;

        public RequestHandler(String name, Predicate<HttpServerExchange> handlePredicate, HttpHandler handler) {
            this.name = name;
            this.handlePredicate = handlePredicate;
            this.handler = handler;
        }

        public String getName() {
            return this.name;
        }

        public Predicate<HttpServerExchange> getHandlePredicate() {
            return this.handlePredicate;
        }

        public HttpHandler getHandler() {
            return this.handler;
        }
    }
}

