/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.keycloak.KeycloakPrincipal;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.basic.BasicAuthContext;
import org.openremote.container.security.keycloak.AccessTokenAuthContext;
import org.openremote.container.web.WebApplication;
import org.openremote.model.Container;

public class WebResource
implements AuthContext {
    @Context
    protected Application application;
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders httpHeaders;
    @Context
    protected SecurityContext securityContext;

    public WebApplication getApplication() {
        return (WebApplication)this.application;
    }

    public Container getContainer() {
        return this.getApplication().getContainer();
    }

    public String getClientRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    public String getRequestRealmName() {
        return this.request.getHeader("Realm");
    }

    public boolean isAuthenticated() {
        return this.securityContext.getUserPrincipal() != null;
    }

    public AuthContext getAuthContext() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            return null;
        }
        if (principal instanceof KeycloakPrincipal) {
            KeycloakPrincipal keycloakPrincipal = (KeycloakPrincipal)principal;
            return new AccessTokenAuthContext(keycloakPrincipal.getKeycloakSecurityContext().getRealm(), keycloakPrincipal.getKeycloakSecurityContext().getToken());
        }
        if (principal instanceof BasicAuthContext) {
            return (BasicAuthContext)principal;
        }
        throw new WebApplicationException("Unsupported user principal type: " + principal, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @Override
    public String getAuthenticatedRealmName() {
        return this.isAuthenticated() ? this.getAuthContext().getAuthenticatedRealmName() : null;
    }

    @Override
    public String getUsername() {
        return this.isAuthenticated() ? this.getAuthContext().getUsername() : null;
    }

    @Override
    public String getUserId() {
        return this.isAuthenticated() ? this.getAuthContext().getUserId() : null;
    }

    @Override
    public String getClientId() {
        return this.isAuthenticated() ? this.getAuthContext().getClientId() : null;
    }

    @Override
    public boolean hasRealmRole(String role) {
        return this.isAuthenticated() && this.getAuthContext().hasRealmRole(role);
    }

    @Override
    public boolean hasResourceRole(String role, String resource) {
        return this.isAuthenticated() && this.getAuthContext().hasResourceRole(role, resource);
    }
}

