/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.net.URI;
import javax.ws.rs.client.Client;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openremote.container.json.JacksonConfig;
import org.openremote.container.security.BearerAuthClientRequestFilter;
import org.openremote.container.security.ClientSecretRequestFilter;
import org.openremote.container.web.ProxyClientRequestFilter;

public interface WebClient {
    public static final String REQUEST_PROPERTY_ACCESS_TOKEN = WebClient.class.getName() + ".accessToken";
    public static final String REQUEST_PROPERTY_CLIENT_ID = WebClient.class.getName() + ".clientId";
    public static final String REQUEST_PROPERTY_CLIENT_SECRET = WebClient.class.getName() + ".clientSecret";
    public static final String REQUEST_PROPERTY_X_FORWARDED_FOR = WebClient.class.getName() + ".xForwardedFor";
    public static final String REQUEST_PROPERTY_X_FORWARDED_HOST = WebClient.class.getName() + ".xForwardedHost";
    public static final String REQUEST_PROPERTY_X_FORWARDED_PROTO = WebClient.class.getName() + ".xForwardedProto";
    public static final String REQUEST_PROPERTY_X_FORWARDED_PORT = WebClient.class.getName() + ".xForwardedPort";

    public static ResteasyClientBuilder registerDefaults(ResteasyClientBuilder builder) {
        return builder.register((Object)new JacksonConfig()).register((Object)new ProxyClientRequestFilter()).register((Object)new BearerAuthClientRequestFilter()).register((Object)new ClientSecretRequestFilter());
    }

    public static ResteasyWebTarget getTarget(Client client, URI uri, String accessToken, String forwardFor, URI forwardUri) {
        return WebClient.getTarget(client, uri, accessToken, forwardFor, forwardUri != null ? forwardUri.getHost() : null, forwardUri != null ? forwardUri.getScheme() : null, forwardUri != null ? Integer.valueOf(forwardUri.getPort()) : null);
    }

    public static ResteasyWebTarget getTarget(Client client, URI uri, String accessToken, String forwardFor, String forwardHost, String forwardProto, Integer forwardPort) {
        ResteasyWebTarget target = (ResteasyWebTarget)client.target(uri);
        if (accessToken != null) {
            target.property(REQUEST_PROPERTY_ACCESS_TOKEN, (Object)accessToken);
        }
        if (forwardFor != null) {
            target.property(REQUEST_PROPERTY_X_FORWARDED_FOR, (Object)forwardFor);
        }
        if (forwardHost != null) {
            target.property(REQUEST_PROPERTY_X_FORWARDED_HOST, (Object)forwardHost);
        }
        if (forwardProto != null) {
            target.property(REQUEST_PROPERTY_X_FORWARDED_PROTO, (Object)forwardProto);
        }
        if (forwardPort != null) {
            target.property(REQUEST_PROPERTY_X_FORWARDED_PORT, (Object)forwardPort);
        }
        return target;
    }

    public static ResteasyWebTarget getTarget(Client client, URI uri, String clientId, String clientSecret) {
        ResteasyWebTarget target = WebClient.getTarget(client, uri, null, null, null, null, null);
        if (clientId != null) {
            target.property(REQUEST_PROPERTY_CLIENT_ID, (Object)clientId);
        }
        if (clientSecret != null) {
            target.property(REQUEST_PROPERTY_CLIENT_SECRET, (Object)clientSecret);
        }
        return target;
    }

    public static <T> T getTargetResource(ResteasyWebTarget target, Class<T> resourceType) {
        return (T)target.proxy(resourceType);
    }
}

