/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
public class QueryParameterInjectorFilter
implements ClientRequestFilter {
    public static final String DYNAMIC_VALUE_PROPERTY = QueryParameterInjectorFilter.class.getName() + ".dynamicValue";
    public static final String QUERY_PARAMETERS_PROPERTY = QueryParameterInjectorFilter.class.getName() + ".params";
    public static final Pattern DYNAMIC_TIME_PATTERN = Pattern.compile("\"?\\{\\$time#?([a-z,A-Z,\\-,\\s,:]*)#?(-?\\d*)?}\"?");

    public void filter(ClientRequestContext requestContext) throws IOException {
        String dynamicValue;
        MultivaluedMap queryParameters = (MultivaluedMap)requestContext.getProperty(QUERY_PARAMETERS_PROPERTY);
        String string = dynamicValue = requestContext.getProperty(DYNAMIC_VALUE_PROPERTY) != null ? (String)requestContext.getProperty(DYNAMIC_VALUE_PROPERTY) : "";
        if (queryParameters == null) {
            return;
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)requestContext.getUri());
        queryParameters.forEach((name, values) -> {
            Object[] formattedValues = values.stream().map(v -> {
                Matcher matcher = DYNAMIC_TIME_PATTERN.matcher(v = v.replaceAll("\"?\\{\\$value}\"?", dynamicValue));
                if (matcher.find()) {
                    long millisToAdd = 0L;
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                    if (matcher.groupCount() > 0) {
                        dateTimeFormatter = DateTimeFormatter.ofPattern(matcher.group(1));
                    }
                    if (matcher.groupCount() == 2) {
                        millisToAdd = Long.parseLong(matcher.group(2));
                    }
                    v = v.replaceAll("\"?\\{\\$time#?([a-z,A-Z,\\-,\\s,:]*)#?(-?\\d*)?}\"?", dateTimeFormatter.format(Instant.now().plusMillis(millisToAdd).atZone(ZoneId.systemDefault())));
                }
                return v;
            }).toArray();
            uriBuilder.queryParam(name, formattedValues);
        });
        requestContext.setUri(uriBuilder.build(new Object[0]));
    }
}

