/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.openremote.model.syslog.SyslogCategory;

public class PermanentFailureFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, PermanentFailureFilter.class);
    protected boolean failed;
    protected List<Integer> failureResponses;

    public PermanentFailureFilter(List<Integer> failureResponses) {
        this.failureResponses = failureResponses;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.failed) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build());
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (this.failureResponses == null) {
            return;
        }
        if (this.failureResponses.contains(responseContext.getStatus())) {
            LOG.warning("Server returned a response code that is set as permanent failure so future requests will be blocked: " + responseContext.getStatus());
            this.failed = true;
        }
    }
}

