/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.net.SocketException;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.util.BasicAuthHelper;
import org.openremote.container.web.OAuthServerResponse;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.auth.OAuthRefreshTokenGrant;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;

public class OAuthFilter
implements ClientRequestFilter {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, OAuthFilter.class);
    public static final String BEARER_AUTH = "Bearer";
    protected OAuthServerResponse authServerResponse;
    protected ResteasyClient client;
    protected WebTarget authTarget;
    protected OAuthGrant oAuthGrant;

    public OAuthFilter(ResteasyClient client, OAuthGrant oAuthGrant) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(oAuthGrant);
        this.client = client;
        this.authTarget = client.target(oAuthGrant.getTokenEndpointUri());
        this.oAuthGrant = oAuthGrant;
    }

    public String getAuthHeader() throws SocketException {
        String accessToken = this.getAccessToken();
        if (!TextUtil.isNullOrEmpty((String)accessToken)) {
            return "Bearer " + accessToken;
        }
        return null;
    }

    public synchronized String getAccessToken() throws SocketException {
        boolean updateRequired;
        LocalDateTime expiryDateTime = this.authServerResponse == null ? null : this.authServerResponse.getExpiryDateTime();
        boolean bl = updateRequired = expiryDateTime == null || expiryDateTime.minusSeconds(10L).isBefore(LocalDateTime.now());
        if (updateRequired) {
            this.updateToken();
        }
        return this.authServerResponse != null ? this.authServerResponse.accessToken : null;
    }

    protected synchronized void updateToken() throws SocketException {
        LOG.fine("Updating OAuth token");
        try (Response response = null;){
            if (this.authServerResponse != null && this.authServerResponse.refreshToken != null) {
                LOG.fine("Using Refresh grant");
                response = this.requestTokenUsingRefresh();
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    LOG.info("OAuth token refresh failed, trying a full authentication");
                    this.authServerResponse = null;
                    this.updateToken();
                    return;
                }
            } else {
                LOG.fine("Doing full authentication");
                response = this.requestToken();
            }
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                this.authServerResponse = null;
                LOG.warning("OAuth server response error: " + response.getStatus());
                throw new RuntimeException("OAuth server response error: " + response.getStatus());
            }
            this.authServerResponse = (OAuthServerResponse)response.readEntity(OAuthServerResponse.class);
            LOG.finest("OAuth server successfully returned an access token");
        }
    }

    protected Response requestTokenUsingRefresh() throws SocketException {
        OAuthRefreshTokenGrant refreshGrant = new OAuthRefreshTokenGrant(this.oAuthGrant.getTokenEndpointUri(), this.oAuthGrant.getClientId(), this.oAuthGrant.getClientSecret(), this.oAuthGrant.getScope(), this.authServerResponse.refreshToken);
        return this.authTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)new Form(refreshGrant.asMultivaluedMap()), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    protected Response requestToken() throws SocketException {
        Invocation.Builder builder = this.authTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (this.oAuthGrant.isBasicAuthHeader()) {
            builder.header("Authorization", (Object)BasicAuthHelper.createHeader((String)this.oAuthGrant.getClientId(), (String)this.oAuthGrant.getClientSecret()));
        }
        return builder.post(Entity.entity((Object)new Form(this.oAuthGrant.asMultivaluedMap()), (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
    }

    public synchronized void updateGrant(OAuthGrant grant) {
        this.authServerResponse = null;
        this.oAuthGrant = grant;
        this.authTarget = this.client.target(this.oAuthGrant.getTokenEndpointUri());
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        requestContext.getHeaders().putSingle((Object)"Authorization", (Object)this.getAuthHeader());
    }
}

