/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

@Provider
@Priority(value=4000)
public class GZIPEncodingInterceptor
implements WriterInterceptor {
    protected final boolean enabled;

    public GZIPEncodingInterceptor(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", (Object)this.getClass().getName());
        Object encoding = context.getProperty("Content-Encoding");
        if (this.enabled && encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(old, null);
            context.getHeaders().remove((Object)"Content-Length");
            context.getHeaders().add((Object)"Content-Encoding", (Object)"gzip");
            context.setOutputStream((OutputStream)((Object)gzipOutputStream));
            try {
                context.proceed();
            }
            finally {
                if (gzipOutputStream.getGzip() != null) {
                    gzipOutputStream.getGzip().finish();
                }
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }

    public static class CommittedGZIPOutputStream
    extends CommitHeaderOutputStream {
        protected GZIPOutputStream gzip;

        protected CommittedGZIPOutputStream(OutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            super(delegate, headers);
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        public synchronized void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate);
                this.delegate = this.gzip;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

