/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.engines.PassthroughTrustManager;
import org.jboss.resteasy.client.jaxrs.engines.factory.ApacheHttpClient4EngineFactory;

public class ExtensibleResteasyClientBuilder
extends ResteasyClientBuilder {
    public ResteasyClient build() {
        this.httpEngine((ClientHttpEngine)ExtensibleResteasyClientBuilder.initDefaultEngine43(this));
        return super.build();
    }

    public ResteasyClient buildOld() {
        throw new UnsupportedOperationException("Just don't...");
    }

    public HttpClientBuilder configure(HttpClientBuilder httpClientBuilder) {
        return httpClientBuilder;
    }

    public static ApacheHttpClient43Engine initDefaultEngine43(final ExtensibleResteasyClientBuilder that) {
        CloseableHttpClient httpClient = null;
        VerifierWrapper verifier = null;
        if (that.verifier != null) {
            verifier = new VerifierWrapper(that.verifier);
        } else {
            switch (that.policy) {
                case ANY: {
                    verifier = new NoopHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new DefaultHostnameVerifier();
                    break;
                }
                case STRICT: {
                    verifier = new DefaultHostnameVerifier();
                }
            }
        }
        try {
            SSLConnectionSocketFactory sslsf = null;
            SSLContext theContext = that.sslContext;
            if (that.disableTrustManager) {
                theContext = SSLContext.getInstance("SSL");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new NoopHostnameVerifier();
                sslsf = new SSLConnectionSocketFactory(theContext, (HostnameVerifier)verifier);
            } else if (theContext != null) {
                sslsf = new SSLConnectionSocketFactory(theContext, verifier){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        that.prepareSocketForSni(socket);
                    }
                };
            } else if (that.clientKeyStore != null || that.truststore != null) {
                SSLContext ctx = SSLContexts.custom().setProtocol("TLS").setSecureRandom(null).loadKeyMaterial(that.clientKeyStore, that.clientPrivateKeyPassword != null ? that.clientPrivateKeyPassword.toCharArray() : null).loadTrustMaterial(that.truststore, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
                sslsf = new SSLConnectionSocketFactory(ctx, verifier){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        that.prepareSocketForSni(socket);
                    }
                };
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslsf = new SSLConnectionSocketFactory(tlsContext, (HostnameVerifier)verifier);
            }
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            BasicHttpClientConnectionManager cm = null;
            if (that.connectionPoolSize > 0) {
                PoolingHttpClientConnectionManager tcm = new PoolingHttpClientConnectionManager(registry, null, null, null, that.connectionTTL, that.connectionTTLUnit);
                tcm.setMaxTotal(that.connectionPoolSize);
                if (that.maxPooledPerRoute == 0) {
                    that.maxPooledPerRoute = that.connectionPoolSize;
                }
                tcm.setDefaultMaxPerRoute(that.maxPooledPerRoute);
                cm = tcm;
            } else {
                cm = new BasicHttpClientConnectionManager((Lookup)registry);
            }
            RequestConfig.Builder rcBuilder = RequestConfig.custom();
            if (that.socketTimeout > -1L) {
                rcBuilder.setSocketTimeout((int)that.socketTimeoutUnits.toMillis(that.socketTimeout));
            }
            if (that.establishConnectionTimeout > -1L) {
                rcBuilder.setConnectTimeout((int)that.establishConnectionTimeoutUnits.toMillis(that.establishConnectionTimeout));
            }
            if (that.connectionCheckoutTimeoutMs > -1) {
                rcBuilder.setConnectionRequestTimeout(that.connectionCheckoutTimeoutMs);
            }
            httpClient = that.configure(HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(rcBuilder.build()).setProxy(that.defaultProxy).disableContentCompression()).build();
            ApacheHttpClient43Engine engine = (ApacheHttpClient43Engine)ApacheHttpClient4EngineFactory.create((HttpClient)httpClient, (boolean)true);
            engine.setResponseBufferSize(that.responseBufferSize);
            engine.setHostnameVerifier((HostnameVerifier)verifier);
            engine.setSslContext(theContext);
            return engine;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class VerifierWrapper
    implements HostnameVerifier {
        protected HostnameVerifier verifier;

        VerifierWrapper(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.verifier.verify(s, sslSession);
        }
    }
}

