/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.UndertowContainerProvider;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.keycloak.KeycloakPrincipal;
import org.openremote.container.security.AuthContext;
import org.openremote.container.security.basic.BasicAuthContext;
import org.openremote.container.security.keycloak.AccessTokenAuthContext;
import org.openremote.container.web.WebService;
import org.openremote.container.web.socket.WebsocketAdapter;
import org.openremote.container.web.socket.WebsocketComponent;
import org.openremote.container.web.socket.WebsocketConsumer;
import org.openremote.model.Container;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;

public class DefaultWebsocketComponent
extends WebsocketComponent {
    public static final String WEBSOCKET_PATH = "/websocket";
    private static final Logger LOG = Logger.getLogger(DefaultWebsocketComponent.class.getName());
    protected final Container container;
    protected final WebService webService;
    protected final String allowedOrigin;
    protected DeploymentInfo deploymentInfo;
    protected WebService.RequestHandler websocketHttpHandler;

    public DefaultWebsocketComponent(Container container, String allowedOrigin) {
        this.container = container;
        this.webService = (WebService)container.getService(WebService.class);
        this.allowedOrigin = allowedOrigin;
    }

    @Override
    protected void deploy() throws Exception {
        WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
        this.getConsumers().forEach((key, value) -> {
            String endpointPath = "/websocket/" + key;
            LOG.info("Deploying websocket endpoint: " + endpointPath);
            webSocketDeploymentInfo.addEndpoint(ServerEndpointConfig.Builder.create(WebsocketAdapter.class, (String)endpointPath).configurator((ServerEndpointConfig.Configurator)new DefaultContainerConfigurator((WebsocketConsumer)((Object)value)){
                final /* synthetic */ WebsocketConsumer val$value;
                {
                    this.val$value = websocketConsumer;
                }

                public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                    return (T)((Object)new WebsocketAdapter(this.val$value));
                }

                public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
                    String realm = Optional.ofNullable((List)request.getHeaders().get("Realm")).map(realms -> realms.isEmpty() ? null : (String)realms.get(0)).orElse(null);
                    Principal principal = request.getUserPrincipal();
                    AuthContext authContext = null;
                    if (principal instanceof KeycloakPrincipal) {
                        KeycloakPrincipal keycloakPrincipal = (KeycloakPrincipal)principal;
                        authContext = new AccessTokenAuthContext(keycloakPrincipal.getKeycloakSecurityContext().getRealm(), keycloakPrincipal.getKeycloakSecurityContext().getToken());
                    } else if (principal instanceof BasicAuthContext) {
                        authContext = (BasicAuthContext)principal;
                    } else if (principal != null) {
                        LOG.info("Unsupported user principal type: " + principal);
                    }
                    config.getUserProperties().put("connection.auth", authContext);
                    config.getUserProperties().put("connection.realm", realm);
                    super.modifyHandshake(config, request, response);
                }
            }).build());
        });
        webSocketDeploymentInfo.setDispatchToWorkerThread(false);
        webSocketDeploymentInfo.setWorker(Xnio.getInstance().createWorker(OptionMap.builder().set(Options.WORKER_TASK_MAX_THREADS, 1).set(Options.WORKER_NAME, (Object)"WebsocketInternalClient").set(Options.THREAD_DAEMON, true).getMap()));
        boolean directBuffers = Boolean.getBoolean("io.undertow.websockets.direct-buffers");
        webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(directBuffers, 1024, 100, 12));
        String deploymentName = "WebSocket Deployment";
        this.deploymentInfo = new DeploymentInfo().setDeploymentName(deploymentName).setContextPath(WEBSOCKET_PATH).addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo).setClassLoader(WebsocketComponent.class.getClassLoader());
        WebResourceCollection resourceCollection = new WebResourceCollection();
        resourceCollection.addUrlPattern("/*");
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
        constraint.addWebResourceCollection(resourceCollection);
        this.deploymentInfo.addSecurityConstraints(new SecurityConstraint[]{constraint});
        HttpHandler handler = WebService.addServletDeployment(this.container, this.deploymentInfo, true);
        this.websocketHttpHandler = WebService.pathStartsWithHandler(deploymentName, WEBSOCKET_PATH, handler);
        this.webService.getRequestHandlers().add(0, this.websocketHttpHandler);
    }

    @Override
    protected void undeploy() throws Exception {
        if (this.deploymentInfo != null) {
            this.webService.removeServletDeployment(this.deploymentInfo);
            this.deploymentInfo = null;
        }
        this.webService.getRequestHandlers().remove(this.websocketHttpHandler);
        this.websocketHttpHandler = null;
    }

    static {
        UndertowContainerProvider.disableDefaultContainer();
    }
}

