/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.web;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
@Priority(value=4001)
public class AlreadyGzippedWriterInterceptor
implements WriterInterceptor {
    public static final String[] ALREADY_ZIPPED_MEDIA_TYPES = new String[]{"application/vnd.mapbox-vector-tile"};

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (context.getMediaType() != null && Arrays.asList(ALREADY_ZIPPED_MEDIA_TYPES).contains(context.getMediaType().toString())) {
            context.getHeaders().putSingle((Object)"Content-Encoding", (Object)"gzip");
        }
        context.proceed();
    }
}

