/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.util;

import com.devskiller.friendly_id.Url62;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.NameBasedGenerator;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.io.Serializable;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.openremote.model.IdentifiableEntity;

public class UniqueIdentifierGenerator
implements IdentifierGenerator {
    protected static final RandomBasedGenerator randomGenerator = Generators.randomBasedGenerator();
    protected static final NameBasedGenerator nameGenerator = Generators.nameBasedGenerator();

    public Serializable generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        IdentifiableEntity identifiableEntity;
        if (object instanceof IdentifiableEntity && (identifiableEntity = (IdentifiableEntity)object).getId() != null) {
            return identifiableEntity.getId();
        }
        return UniqueIdentifierGenerator.generateId();
    }

    public static String generateId() {
        return Url62.encode((UUID)randomGenerator.generate());
    }

    public static String generateId(String name) {
        return Url62.encode((UUID)nameGenerator.generate(name));
    }

    public static String generateId(byte[] bytes) {
        return Url62.encode((UUID)nameGenerator.generate(bytes));
    }
}

