/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.util;

import java.math.BigDecimal;
import java.util.Map;

public class MapAccess {
    protected MapAccess() {
    }

    public static String getString(Map<String, String> map, String key, String defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static boolean getBoolean(Map<String, String> map, String key, boolean defaultValue) {
        if (map.containsKey(key)) {
            try {
                return Boolean.valueOf(map.get(key));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static int getInteger(Map<String, String> map, String key, int defaultValue) {
        if (map.containsKey(key)) {
            try {
                return Integer.valueOf(map.get(key));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static BigDecimal getDecimal(Map<String, String> map, String key, BigDecimal defaultValue) {
        if (map.containsKey(key)) {
            try {
                return new BigDecimal(map.get(key));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

