/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.logging.LogManager;
import org.openremote.model.Container;
import org.openremote.model.util.TextUtil;

public class LogUtil {
    public static final String OR_LOGGING_CONFIG_FILE = "OR_LOGGING_CONFIG_FILE";

    protected LogUtil() {
    }

    public static void configureLogging() throws ExceptionInInitializerError {
        block29: {
            if (System.getProperty("java.util.logging.config.file") == null) {
                if (!TextUtil.isNullOrEmpty((String)System.getenv(OR_LOGGING_CONFIG_FILE))) {
                    Path loggingConfigFile = Paths.get(System.getenv(OR_LOGGING_CONFIG_FILE), new String[0]);
                    if (!Files.isReadable(loggingConfigFile)) {
                        throw new ExceptionInInitializerError("OR_LOGGING_CONFIG_FILE is not readable: " + loggingConfigFile.toAbsolutePath());
                    }
                    try (InputStream is = Files.newInputStream(loggingConfigFile, new OpenOption[0]);){
                        System.out.println("Using logging configuration: " + loggingConfigFile.toAbsolutePath());
                        LogManager.getLogManager().readConfiguration(is);
                        break block29;
                    }
                    catch (Exception ex) {
                        throw new ExceptionInInitializerError(ex);
                    }
                }
                if (Files.isReadable(Paths.get("/deployment/manager/logging.properties", new String[0]))) {
                    try (InputStream is = Files.newInputStream(Paths.get("/deployment/manager/logging.properties", new String[0]), new OpenOption[0]);){
                        System.out.println("Using logging configuration: /deployment/manager/logging.properties");
                        LogManager.getLogManager().readConfiguration(is);
                        break block29;
                    }
                    catch (Exception ex) {
                        throw new ExceptionInInitializerError(ex);
                    }
                }
                String devModeStr = System.getenv("OR_DEV_MODE");
                boolean isDevMode = devModeStr == null || "TRUE".equals(devModeStr.toUpperCase(Locale.ROOT));
                String loggingFile = isDevMode ? "logging-dev.properties" : "logging.properties";
                try (InputStream is = Container.class.getClassLoader().getResourceAsStream(loggingFile);){
                    if (is != null) {
                        System.out.println("Using logging configuration on classpath: " + loggingFile);
                        LogManager.getLogManager().readConfiguration(is);
                    }
                }
                catch (Exception ex) {
                    throw new ExceptionInInitializerError(ex);
                }
            }
        }
    }
}

