/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.openremote.model.util.TextUtil;

public class LogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        OffsetDateTime date = this.fromMillis(record.getMillis());
        StringBuilder sb = new StringBuilder(250);
        sb.append(TextUtil.pad((String)date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")), (int)24));
        sb.append(" ");
        sb.append(TextUtil.pad((String)record.getLevel().toString(), (int)7));
        sb.append(" ");
        sb.append("[").append(TextUtil.pad((String)Thread.currentThread().getName().replaceFirst("(.{24}).+(.{4})", "$1..$2"), (int)30)).append("] ");
        sb.append(TextUtil.pad((String)TextUtil.truncate((String)record.getLoggerName(), (int)40, (boolean)true), (int)40));
        sb.append(" : ");
        sb.append(this.formatMessage(record));
        sb.append("\n");
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            StringWriter sink = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)sink, true));
            sb.append(sink.toString());
        }
        return sb.toString();
    }

    protected OffsetDateTime fromMillis(long epochMillis) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
    }
}

