/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.timer;

import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.openremote.container.util.MapAccess;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;

public class TimerService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(TimerService.class.getName());
    public static final String TIMER_CLOCK_TYPE = "TIMER_CLOCK_TYPE";
    public static final String TIMER_CLOCK_TYPE_DEFAULT = Clock.REAL.toString();
    public static final int PRIORITY = -2147482348;
    protected Clock clock;

    public int getPriority() {
        return -2147482348;
    }

    public void init(Container container) throws Exception {
        this.clock = Clock.valueOf(MapAccess.getString(container.getConfig(), TIMER_CLOCK_TYPE, TIMER_CLOCK_TYPE_DEFAULT));
        this.clock.init();
    }

    public void start(Container container) throws Exception {
        this.getClock().start();
    }

    public void stop(Container container) throws Exception {
        this.getClock().stop();
    }

    public Clock getClock() {
        return this.clock;
    }

    public long getCurrentTimeMillis() {
        return this.getClock().getCurrentTimeMillis();
    }

    public Instant getNow() {
        return Instant.ofEpochMilli(this.getCurrentTimeMillis());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{clock=" + this.clock + "}";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Clock {
        REAL{

            @Override
            public void init() {
            }

            @Override
            public long getCurrentTimeMillis() {
                return System.currentTimeMillis();
            }

            @Override
            public long advanceTime(long amount, TimeUnit unit) {
                throw new UnsupportedOperationException("Wall clock can not be advanced manually");
            }

            @Override
            public void stop() {
            }

            @Override
            public void start() {
            }

            @Override
            public void reset() {
            }
        }
        ,
        PSEUDO{
            protected AtomicLong offset = new AtomicLong();
            protected Long stopTime;

            @Override
            public void init() {
                long current = this.getCurrentTimeMillis();
                LOG.info("Initialized pseudo clock to: " + current + "/" + new Date(current));
            }

            @Override
            public long getCurrentTimeMillis() {
                return (this.stopTime != null ? this.stopTime : System.currentTimeMillis()) + this.offset.get();
            }

            @Override
            public long advanceTime(long amount, TimeUnit unit) {
                this.offset.addAndGet(unit.toMillis(amount));
                return this.getCurrentTimeMillis();
            }

            @Override
            public void stop() {
                if (this.stopTime == null) {
                    this.stopTime = System.currentTimeMillis();
                }
            }

            @Override
            public void start() {
                if (this.stopTime != null) {
                    this.stopTime = null;
                }
            }

            @Override
            public void reset() {
                this.offset.set(0L);
            }
        };


        public abstract void init();

        public abstract long getCurrentTimeMillis();

        public abstract void stop();

        public abstract void start();

        public abstract void reset();

        public abstract long advanceTime(long var1, TimeUnit var3);
    }
}

