/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security.keycloak;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.NodesRegistrationManagement;
import org.keycloak.adapters.undertow.ChangeSessionId;
import org.keycloak.adapters.undertow.KeycloakServletExtension;
import org.keycloak.adapters.undertow.ServletKeycloakAuthMech;
import org.keycloak.adapters.undertow.ServletPreAuthActionsHandler;
import org.keycloak.adapters.undertow.UndertowAuthenticatedActionsHandler;
import org.keycloak.adapters.undertow.UndertowNodesRegistrationManagementWrapper;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class SimpleKeycloakServletExtension
implements ServletExtension {
    public static final String AUTH_MECHANISM = "SIMPLE_KEYCLOAK";
    protected static Logger log = Logger.getLogger(KeycloakServletExtension.class);
    protected final KeycloakConfigResolver configResolver;
    protected final AdapterDeploymentContext deploymentContext;

    public SimpleKeycloakServletExtension(KeycloakConfigResolver configResolver) {
        this.configResolver = configResolver;
        this.deploymentContext = new AdapterDeploymentContext(configResolver);
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        servletContext.setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        UndertowUserSessionManagement userSessionManagement = new UndertowUserSessionManagement();
        NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
        final ServletKeycloakAuthMech mech = this.createAuthenticationMechanism(deploymentInfo, this.deploymentContext, userSessionManagement, nodesRegistrationManagement);
        UndertowAuthenticatedActionsHandler.Wrapper actions = new UndertowAuthenticatedActionsHandler.Wrapper(this.deploymentContext);
        deploymentInfo.addOuterHandlerChainWrapper((HandlerWrapper)new ServletPreAuthActionsHandler.Wrapper(this.deploymentContext, userSessionManagement));
        deploymentInfo.addAuthenticationMechanism(AUTH_MECHANISM, new AuthenticationMechanismFactory(){

            public AuthenticationMechanism create(String s, IdentityManager identityManager, FormParserFactory formParserFactory, Map<String, String> stringStringMap) {
                return mech;
            }
        });
        deploymentInfo.addInnerHandlerChainWrapper((HandlerWrapper)actions);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                return account;
            }

            public Account verify(String id, Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }

            public Account verify(Credential credential) {
                throw new IllegalStateException("Should never be called in Keycloak flow");
            }
        });
        ServletSessionConfig cookieConfig = deploymentInfo.getServletSessionConfig();
        if (cookieConfig == null) {
            cookieConfig = new ServletSessionConfig();
        }
        if (cookieConfig.getPath() == null) {
            log.debug((Object)("Setting jsession cookie path to: " + deploymentInfo.getContextPath()));
            cookieConfig.setPath(deploymentInfo.getContextPath());
            deploymentInfo.setServletSessionConfig(cookieConfig);
        }
        ChangeSessionId.turnOffChangeSessionIdOnLogin((DeploymentInfo)deploymentInfo);
        deploymentInfo.addListener(new ListenerInfo(UndertowNodesRegistrationManagementWrapper.class, () -> {
            UndertowNodesRegistrationManagementWrapper listener = new UndertowNodesRegistrationManagementWrapper(nodesRegistrationManagement);
            return new ImmediateInstanceHandle((Object)listener);
        }));
    }

    protected ServletKeycloakAuthMech createAuthenticationMechanism(DeploymentInfo deploymentInfo, AdapterDeploymentContext deploymentContext, UndertowUserSessionManagement userSessionManagement, NodesRegistrationManagement nodesRegistrationManagement) {
        log.debug((Object)"creating ServletKeycloakAuthMech");
        String errorPage = this.getErrorPage(deploymentInfo);
        return new ServletKeycloakAuthMech(deploymentContext, userSessionManagement, nodesRegistrationManagement, deploymentInfo.getConfidentialPortManager(), errorPage);
    }

    protected String getErrorPage(DeploymentInfo deploymentInfo) {
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        String errorPage = null;
        if (loginConfig != null) {
            errorPage = loginConfig.getErrorPage();
        }
        return errorPage;
    }
}

