/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security.keycloak;

import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.openremote.container.security.ClientCredentialsAuthForm;
import org.openremote.container.security.PasswordAuthForm;

public interface KeycloakResource {
    @GET
    @Path(value="/")
    @Produces(value={"text/html"})
    public Response getWelcomePage();

    @POST
    @Path(value="realms/{realm}/protocol/openid-connect/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public AccessTokenResponse getAccessToken(@PathParam(value="realm") String var1, @BeanParam PasswordAuthForm var2);

    @POST
    @Path(value="realms/{realm}/protocol/openid-connect/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public AccessTokenResponse getAccessToken(@PathParam(value="realm") String var1, @BeanParam ClientCredentialsAuthForm var2);

    @GET
    @Path(value="realms/{realm}")
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getPublishedRealm(@PathParam(value="realm") String var1);

    @GET
    @Path(value="realms/{realm}/clients-registrations/install/{clientId}")
    @Produces(value={"application/json"})
    public AdapterConfig getAdapterConfig(@PathParam(value="realm") String var1, @PathParam(value="clientId") String var2);
}

