/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security.keycloak;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.openremote.container.security.IdentityProvider;
import org.openremote.container.security.keycloak.KeycloakRealmClient;
import org.openremote.container.security.keycloak.KeycloakResource;
import org.openremote.container.security.keycloak.SimpleKeycloakServletExtension;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.OAuthFilter;
import org.openremote.container.web.WebClient;
import org.openremote.container.web.WebService;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.model.Container;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.auth.OAuthPasswordGrant;

public abstract class KeycloakIdentityProvider
implements IdentityProvider {
    public static final String ADMIN_CLI_CLIENT_ID = "admin-cli";
    public static final String MANAGER_CLIENT_ID = "manager-keycloak";
    public static final List<String> DEFAULT_CLIENTS = Arrays.asList("account", "admin-cli", "broker", "master-realm", "security-admin-console");
    public static final String OR_KEYCLOAK_HOST = "OR_KEYCLOAK_HOST";
    public static final String OR_KEYCLOAK_HOST_DEFAULT = "127.0.0.1";
    public static final String OR_KEYCLOAK_PORT = "OR_KEYCLOAK_PORT";
    public static final int OR_KEYCLOAK_PORT_DEFAULT = 8081;
    public static final String KEYCLOAK_CONNECT_TIMEOUT = "KEYCLOAK_CONNECT_TIMEOUT";
    public static final int KEYCLOAK_CONNECT_TIMEOUT_DEFAULT = 2000;
    public static final String KEYCLOAK_REQUEST_TIMEOUT = "KEYCLOAK_REQUEST_TIMEOUT";
    public static final int KEYCLOAK_REQUEST_TIMEOUT_DEFAULT = 10000;
    public static final String KEYCLOAK_CLIENT_POOL_SIZE = "KEYCLOAK_CLIENT_POOL_SIZE";
    public static final int KEYCLOAK_CLIENT_POOL_SIZE_DEFAULT = 20;
    public static final String OR_IDENTITY_SESSION_MAX_MINUTES = "OR_IDENTITY_SESSION_MAX_MINUTES";
    public static final int OR_IDENTITY_SESSION_MAX_MINUTES_DEFAULT = 1440;
    public static final String OR_IDENTITY_SESSION_OFFLINE_TIMEOUT_MINUTES = "OR_IDENTITY_SESSION_OFFLINE_TIMEOUT_MINUTES";
    public static final int OR_IDENTITY_SESSION_OFFLINE_TIMEOUT_MINUTES_DEFAULT = 2628000;
    public static final String KEYCLOAK_AUTH_PATH = "auth";
    private static final Logger LOG = Logger.getLogger(KeycloakIdentityProvider.class.getName());
    protected UriBuilder keycloakServiceUri;
    protected int sessionTimeoutSeconds;
    protected int sessionMaxSeconds;
    protected int sessionOfflineTimeoutSeconds;
    protected final KeycloakDeployment notAuthenticatedKeycloakDeployment = new KeycloakDeployment();
    protected ResteasyClient httpClient;
    protected ResteasyWebTarget keycloakTarget;
    protected OAuthGrant oAuthGrant;
    protected ConcurrentLinkedQueue<RealmsResource> realmsResourcePool = new ConcurrentLinkedQueue();
    protected LoadingCache<KeycloakRealmClient, KeycloakDeployment> keycloakDeploymentCache;
    protected KeycloakConfigResolver keycloakConfigResolver;
    protected HttpHandler authProxyHandler;

    protected KeycloakIdentityProvider() {
    }

    public OAuthPasswordGrant getDefaultKeycloakGrant(Container container) {
        return new OAuthPasswordGrant(this.getTokenUri("master").toString(), ADMIN_CLI_CLIENT_ID, null, "openid", "admin", container.getConfig().getOrDefault("OR_ADMIN_PASSWORD", "secret"));
    }

    @Override
    public void init(Container container) {
        if (this.httpClient != null) {
            return;
        }
        this.sessionMaxSeconds = MapAccess.getInteger(container.getConfig(), OR_IDENTITY_SESSION_MAX_MINUTES, 1440) * 60;
        if (this.sessionMaxSeconds < 60) {
            throw new IllegalArgumentException("OR_IDENTITY_SESSION_MAX_MINUTES must be more than 1 minute");
        }
        this.sessionTimeoutSeconds = this.sessionMaxSeconds;
        this.sessionOfflineTimeoutSeconds = MapAccess.getInteger(container.getConfig(), OR_IDENTITY_SESSION_OFFLINE_TIMEOUT_MINUTES, 2628000) * 60;
        if (this.sessionOfflineTimeoutSeconds < 60) {
            throw new IllegalArgumentException("OR_IDENTITY_SESSION_OFFLINE_TIMEOUT_MINUTES must be more than 1 minute");
        }
        this.keycloakServiceUri = UriBuilder.fromPath((String)"/").scheme("http").host(MapAccess.getString(container.getConfig(), OR_KEYCLOAK_HOST, OR_KEYCLOAK_HOST_DEFAULT)).port(MapAccess.getInteger(container.getConfig(), OR_KEYCLOAK_PORT, 8081)).path(KEYCLOAK_AUTH_PATH);
        LOG.info("Keycloak service URL: " + this.keycloakServiceUri.build(new Object[0]));
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder().connectTimeout((long)MapAccess.getInteger(container.getConfig(), KEYCLOAK_CONNECT_TIMEOUT, 2000), TimeUnit.MILLISECONDS).readTimeout((long)MapAccess.getInteger(container.getConfig(), KEYCLOAK_REQUEST_TIMEOUT, 10000), TimeUnit.MILLISECONDS).connectionPoolSize(MapAccess.getInteger(container.getConfig(), KEYCLOAK_CLIENT_POOL_SIZE, 20));
        this.httpClient = WebClient.registerDefaults(clientBuilder).build();
        this.setActiveCredentials((OAuthGrant)this.getDefaultKeycloakGrant(container));
        this.keycloakDeploymentCache = this.createKeycloakDeploymentCache();
        this.keycloakConfigResolver = request -> {
            String realm = request.getHeader("Realm");
            if (realm == null || realm.length() == 0) {
                LOG.finer("No realm in request, no authentication will be attempted: " + request.getURI());
                return this.notAuthenticatedKeycloakDeployment;
            }
            KeycloakDeployment keycloakDeployment = this.getKeycloakDeployment(realm, "openremote");
            if (keycloakDeployment == null) {
                LOG.fine("No Keycloak deployment available for realm, no authentication will be attempted: " + request.getURI());
                return this.notAuthenticatedKeycloakDeployment;
            }
            return keycloakDeployment;
        };
        if (container.isDevMode()) {
            this.authProxyHandler = ProxyHandler.builder().setProxyClient((ProxyClient)new LoadBalancingProxyClient().addHost(this.keycloakServiceUri.clone().replacePath("").build(new Object[0]))).setMaxRequestTime(MapAccess.getInteger(container.getConfig(), KEYCLOAK_REQUEST_TIMEOUT, 10000)).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).setReuseXForwarded(true).build();
        }
        this.waitForKeycloak();
        LOG.info("Keycloak identity provider available: " + this.keycloakServiceUri.build(new Object[0]));
    }

    @Override
    public void start(Container container) {
    }

    @Override
    public void stop(Container container) {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    @Override
    public void secureDeployment(DeploymentInfo deploymentInfo) {
        LoginConfig loginConfig = new LoginConfig("SIMPLE_KEYCLOAK", "OpenRemote");
        deploymentInfo.setLoginConfig(loginConfig);
        deploymentInfo.addServletExtension((ServletExtension)new SimpleKeycloakServletExtension(this.keycloakConfigResolver));
    }

    public KeycloakResource getKeycloak() {
        return (KeycloakResource)this.keycloakTarget.proxy(KeycloakResource.class);
    }

    protected void syncUsers(String componentId, String realm, String action) {
        this.getRealms(realmsResource -> {
            realmsResource.realm(realm).userStorage().syncUsers(componentId, action);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized <T> T getRealms(Function<RealmsResource, T> consumer) {
        ResteasyWebTarget target = this.keycloakTarget;
        RealmsResource realmsResource = this.realmsResourcePool.poll();
        if (realmsResource == null) {
            realmsResource = (RealmsResource)this.keycloakTarget.proxy(RealmsResource.class);
        }
        try {
            T t = consumer.apply(realmsResource);
            return t;
        }
        finally {
            if (target == this.keycloakTarget) {
                this.realmsResourcePool.offer(realmsResource);
            }
        }
    }

    protected void waitForKeycloak() {
        boolean keycloakAvailable = false;
        WebTargetBuilder targetBuilder = new WebTargetBuilder(this.httpClient, this.keycloakServiceUri.build(new Object[0]));
        ResteasyWebTarget target = targetBuilder.build();
        KeycloakResource keycloakResource = (KeycloakResource)target.proxy(KeycloakResource.class);
        while (!keycloakAvailable) {
            LOG.info("Connecting to Keycloak server: " + this.keycloakServiceUri.build(new Object[0]));
            try {
                this.pingKeycloak(keycloakResource);
                keycloakAvailable = true;
            }
            catch (Exception ex) {
                LOG.info("Keycloak server not available, waiting...");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected void pingKeycloak(KeycloakResource resource) throws Exception {
        try (Response response = null;){
            response = resource.getWelcomePage();
            if (response != null && (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL || response.getStatusInfo().getFamily() == Response.Status.Family.REDIRECTION)) {
                return;
            }
            throw new Exception();
        }
    }

    public synchronized KeycloakDeployment getKeycloakDeployment(String realm, String clientId) {
        try {
            return (KeycloakDeployment)this.keycloakDeploymentCache.get((Object)new KeycloakRealmClient(realm, clientId));
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof NotFoundException) {
                LOG.fine("Client '" + clientId + "' for realm '" + realm + "' not found on identity provider");
            } else {
                LOG.log(Level.WARNING, "Error loading client '" + clientId + "' for realm '" + realm + "' from identity provider, exception from call to identity provider follows", ex);
            }
            return null;
        }
    }

    public URI getTokenUri(String realm) {
        return this.keycloakServiceUri.clone().path("realms").path(realm).path("protocol/openid-connect/token").build(new Object[0]);
    }

    public Supplier<String> getAccessTokenSupplier(OAuthGrant grant) {
        OAuthFilter oAuthFilter = new OAuthFilter(this.httpClient, grant);
        return () -> {
            try {
                return oAuthFilter.getAccessToken();
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Failed to get OAuth access token using grant: " + grant, e);
                return null;
            }
        };
    }

    public synchronized void setActiveCredentials(OAuthGrant grant) {
        if (Objects.equals(this.oAuthGrant, grant)) {
            return;
        }
        this.oAuthGrant = grant;
        if (grant != null) {
            grant.setTokenEndpointUri(this.getTokenUri("master").toString());
        }
        URI proxyURI = this.keycloakServiceUri.build(new Object[0]);
        WebTargetBuilder targetBuilder = new WebTargetBuilder(this.httpClient, proxyURI).setOAuthAuthentication(grant);
        this.keycloakTarget = targetBuilder.build();
        this.realmsResourcePool.clear();
        LOG.info("Keycloak proxy URI set to: " + proxyURI);
    }

    protected LoadingCache<KeycloakRealmClient, KeycloakDeployment> createKeycloakDeploymentCache() {
        CacheLoader<KeycloakRealmClient, KeycloakDeployment> loader = new CacheLoader<KeycloakRealmClient, KeycloakDeployment>(){

            public KeycloakDeployment load(KeycloakRealmClient keycloakRealmClient) {
                LOG.fine("Loading adapter config for client '" + keycloakRealmClient.clientId + "' in realm '" + keycloakRealmClient.realm + "'");
                KeycloakResource keycloak = (KeycloakResource)WebClient.getTarget((Client)KeycloakIdentityProvider.this.httpClient, KeycloakIdentityProvider.this.keycloakServiceUri.build(new Object[0]), null, null, null).proxy(KeycloakResource.class);
                AdapterConfig adapterConfig = keycloak.getAdapterConfig(keycloakRealmClient.realm, "openremote");
                adapterConfig.setAuthServerUrl(KeycloakIdentityProvider.this.keycloakServiceUri.clone().build(new Object[0]).toString());
                return KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
            }
        };
        return CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)loader);
    }

    protected void enableAuthProxy(WebService webService) {
        if (this.authProxyHandler == null) {
            throw new IllegalStateException("Initialize this service first");
        }
        LOG.info("Enabling auth reverse proxy (passing requests through to Keycloak) on web context: /auth");
        webService.getRequestHandlers().add(0, WebService.pathStartsWithHandler("Keycloak auth proxy", "/auth", this.authProxyHandler));
    }

    protected abstract void addClientRedirectUris(String var1, List<String> var2, boolean var3);
}

