/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security.keycloak;

import org.keycloak.representations.AccessToken;
import org.openremote.container.security.AuthContext;

public class AccessTokenAuthContext
implements AuthContext {
    protected final String authenticatedRealm;
    protected final AccessToken accessToken;

    public AccessTokenAuthContext(String authenticatedRealm, AccessToken accessToken) {
        this.authenticatedRealm = authenticatedRealm;
        this.accessToken = accessToken;
    }

    @Override
    public String getAuthenticatedRealmName() {
        return this.authenticatedRealm;
    }

    @Override
    public String getUsername() {
        return this.accessToken.getPreferredUsername();
    }

    @Override
    public String getUserId() {
        return this.accessToken.getSubject();
    }

    @Override
    public String getClientId() {
        return this.accessToken.getIssuedFor();
    }

    @Override
    public boolean hasRealmRole(String role) {
        return this.accessToken.getRealmAccess() != null && this.accessToken.getRealmAccess().isUserInRole(role);
    }

    @Override
    public boolean hasResourceRole(String role, String resource) {
        return this.accessToken.getResourceAccess().containsKey(resource) && ((AccessToken.Access)this.accessToken.getResourceAccess().get(resource)).isUserInRole(role);
    }
}

