/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security.basic;

import io.undertow.UndertowMessages;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.util.Headers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.security.IdentityProvider;
import org.openremote.container.security.basic.BasicAuthContext;
import org.openremote.container.security.basic.PasswordStorage;
import org.openremote.model.Container;

public abstract class BasicIdentityProvider
implements IdentityProvider {
    private static final Logger LOG = Logger.getLogger(BasicIdentityProvider.class.getName());
    protected PersistenceService persistenceService;

    @Override
    public void init(Container container) {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.persistenceService.getDefaultSchemaLocations().add("classpath:org/openremote/container/persistence/schema/basicidentityprovider");
        this.persistenceService.getSchemas().add("public");
    }

    @Override
    public void start(Container container) {
    }

    @Override
    public void stop(Container container) {
    }

    @Override
    public void secureDeployment(DeploymentInfo deploymentInfo) {
        LoginConfig loginConfig = new LoginConfig("OpenRemote");
        deploymentInfo.addAuthenticationMechanism("BASIC-FIX", (AuthenticationMechanismFactory)BasicFixAuthenticationMechanism.FACTORY);
        loginConfig.addFirstAuthMethod(new AuthMethodConfig("BASIC-FIX", Collections.singletonMap("silent", "true")));
        deploymentInfo.setLoginConfig(loginConfig);
        deploymentInfo.setIdentityManager(new IdentityManager(){

            public Account verify(Account account) {
                return null;
            }

            public Account verify(String id, Credential credential) {
                if (credential instanceof PasswordCredential) {
                    PasswordCredential passwordCredential = (PasswordCredential)credential;
                    return BasicIdentityProvider.this.verifyAccount(id, passwordCredential.getPassword());
                }
                LOG.fine("Verification of '" + id + "' failed, no password credentials found, but: " + credential);
                return null;
            }

            public Account verify(Credential credential) {
                return null;
            }
        });
    }

    protected Account verifyAccount(String username, char[] password) {
        LOG.fine("Authentication attempt, querying user: " + username);
        Object[] idAndPassword = this.persistenceService.doReturningTransaction(em -> {
            try {
                return (Object[])em.createNativeQuery("select U.ID, U.PASSWORD from PUBLIC.USER_ENTITY U where U.USERNAME = :username").setParameter("username", (Object)username).getSingleResult();
            }
            catch (NoResultException | NonUniqueResultException ex) {
                return null;
            }
        });
        if (idAndPassword == null) {
            LOG.fine("Authentication failed, no such user: " + username);
            return null;
        }
        LOG.fine("Authentication attempt, verifying password: " + username);
        if (!PasswordStorage.verifyPassword(password, idAndPassword[1].toString())) {
            LOG.fine("Authentication failed, invalid password: " + username);
            return null;
        }
        LOG.fine("Authentication successful: " + username);
        final BasicAuthContext principal = new BasicAuthContext("master", idAndPassword[0].toString(), username);
        return new Account(){

            public Principal getPrincipal() {
                return principal;
            }

            public Set<String> getRoles() {
                return BasicIdentityProvider.this.getDefaultRoles();
            }
        };
    }

    protected abstract Set<String> getDefaultRoles();

    protected static class BasicFixAuthenticationMechanism
    extends BasicAuthenticationMechanism {
        private final boolean silent;
        public static Factory FACTORY = new Factory();

        public BasicFixAuthenticationMechanism(String realmName, String mechanismName, boolean silent, IdentityManager identityManager, Charset charset, Map<Pattern, Charset> userAgentCharsets) {
            super(realmName, mechanismName, false, identityManager, charset, userAgentCharsets);
            this.silent = silent;
        }

        public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
            String authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (authHeader == null) {
                if (this.silent) {
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            return super.authenticate(exchange, securityContext);
        }

        public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
            String authHeader = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (this.silent || authHeader != null) {
                return AuthenticationMechanism.ChallengeResult.NOT_SENT;
            }
            return super.sendChallenge(exchange, securityContext);
        }

        protected static class Factory
        implements AuthenticationMechanismFactory {
            protected Factory() {
            }

            public AuthenticationMechanism create(String mechanismName, IdentityManager identityManager, FormParserFactory formParserFactory, Map<String, String> properties) {
                String realm = properties.get("realm");
                String silent = properties.get("silent");
                String charsetString = properties.get("charset");
                Charset charset = charsetString == null ? StandardCharsets.UTF_8 : Charset.forName(charsetString);
                HashMap<Pattern, Charset> userAgentCharsets = new HashMap<Pattern, Charset>();
                String userAgentString = properties.get("user-agent-charsets");
                if (userAgentString != null) {
                    String[] parts = userAgentString.split(",");
                    if (parts.length % 2 != 0) {
                        throw UndertowMessages.MESSAGES.userAgentCharsetMustHaveEvenNumberOfItems(userAgentString);
                    }
                    for (int i = 0; i < parts.length; i += 2) {
                        Pattern pattern = Pattern.compile(parts[i]);
                        Charset c = Charset.forName(parts[i + 1]);
                        userAgentCharsets.put(pattern, c);
                    }
                }
                return new BasicFixAuthenticationMechanism(realm, mechanismName, silent != null && silent.equals("true"), identityManager, charset, userAgentCharsets);
            }
        }
    }
}

