/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.HttpString;
import java.util.logging.Logger;
import org.openremote.container.security.AuthOverloadHandler;
import org.openremote.container.security.IdentityProvider;
import org.openremote.container.security.keycloak.KeycloakIdentityProvider;
import org.openremote.container.util.MapAccess;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;

public abstract class IdentityService
implements ContainerService {
    public static final int PRIORITY = -2147483558;
    private static final Logger LOG = Logger.getLogger(IdentityService.class.getName());
    public static final String OR_IDENTITY_PROVIDER = "OR_IDENTITY_PROVIDER";
    public static final String OR_IDENTITY_PROVIDER_DEFAULT = "keycloak";
    protected IdentityProvider identityProvider;
    protected boolean devMode;

    public int getPriority() {
        return -2147483558;
    }

    public void init(Container container) throws Exception {
        this.devMode = container.isDevMode();
        String identityProviderType = MapAccess.getString(container.getConfig(), OR_IDENTITY_PROVIDER, OR_IDENTITY_PROVIDER_DEFAULT);
        this.identityProvider = this.createIdentityProvider(container, identityProviderType);
        this.identityProvider.init(container);
    }

    public void start(Container container) throws Exception {
        this.identityProvider.start(container);
    }

    public void stop(Container container) throws Exception {
        this.identityProvider.stop(container);
    }

    public void secureDeployment(DeploymentInfo deploymentInfo) {
        LOG.info("Securing web deployment: " + deploymentInfo.getContextPath());
        deploymentInfo.addInitialHandlerChainWrapper(AuthOverloadHandler::new);
        deploymentInfo.setSecurityDisabled(false);
        this.identityProvider.secureDeployment(deploymentInfo);
        if (this.devMode) {
            deploymentInfo.addOuterHandlerChainWrapper(new HandlerWrapper(){

                public HttpHandler wrap(final HttpHandler handler) {
                    return new HttpHandler(){

                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            if (exchange.isInIoThread()) {
                                exchange.dispatch((HttpHandler)this);
                                return;
                            }
                            String origin = exchange.getRequestHeaders().getFirst("Origin");
                            exchange.getResponseHeaders().add(HttpString.tryFromString((String)"Access-Control-Allow-Origin"), origin);
                            exchange.getResponseHeaders().add(HttpString.tryFromString((String)"Access-Control-Allow-Credentials"), "true");
                            handler.handleRequest(exchange);
                        }
                    };
                }
            });
        }
    }

    public boolean isKeycloakEnabled() {
        return this.identityProvider instanceof KeycloakIdentityProvider;
    }

    public abstract IdentityProvider createIdentityProvider(Container var1, String var2);
}

