/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openremote.container.web.file.HttpFilter;
import org.openremote.model.util.TextUtil;

public class CORSFilter
extends HttpFilter {
    protected boolean allowCredentials = true;
    protected String allowedMethods;
    protected String allowedHeaders;
    protected String exposedHeaders;
    protected int corsMaxAge = -1;
    protected Set<String> allowedOrigins = new HashSet<String>();

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public String getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public String getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public String getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public void setCorsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        String origin = request.getHeader("Origin");
        boolean isOptions = request.getMethod().equals("OPTIONS");
        if (origin == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.originOk(origin)) {
            response.sendError(403, "Origin not allowed");
            return;
        }
        if (isOptions) {
            String requestHeaders;
            String requestMethods;
            response.setStatus(200);
            response.setHeader("Access-Control-Allow-Origin", origin);
            if (this.allowCredentials) {
                response.setHeader("Access-Control-Allow-Credentials", "true");
            }
            if (!TextUtil.isNullOrEmpty((String)(requestMethods = request.getHeader("Access-Control-Request-Method")))) {
                if (this.allowedMethods != null) {
                    requestMethods = this.allowedMethods;
                }
                response.setHeader("Access-Control-Allow-Methods", requestMethods);
            }
            if (!TextUtil.isNullOrEmpty((String)(requestHeaders = request.getHeader("Access-Control-Request-Headers")))) {
                if (this.allowedHeaders != null) {
                    requestHeaders = this.allowedHeaders;
                }
                response.setHeader("Access-Control-Allow-Headers", requestHeaders);
            }
            if (this.corsMaxAge > -1) {
                response.setHeader("Access-Control-Max-Age", Integer.toString(this.corsMaxAge));
            }
        } else {
            response.setHeader("Access-Control-Allow-Origin", origin);
            if (this.allowCredentials) {
                response.setHeader("Access-Control-Allow-Credentials", "true");
            }
            if (this.exposedHeaders != null) {
                response.setHeader("Access-Control-Expose-Headers", this.exposedHeaders);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean originOk(String origin) {
        if (this.allowedOrigins.contains("*")) return true;
        if (this.allowedOrigins.contains(origin)) return true;
        if (!this.allowedOrigins.stream().anyMatch(origin::startsWith)) return false;
        return true;
    }
}

