/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.security;

public interface AuthContext {
    public String getAuthenticatedRealmName();

    public String getUsername();

    public String getUserId();

    public String getClientId();

    default public boolean isSuperUser() {
        return "master".equals(this.getAuthenticatedRealmName()) && this.hasRealmRole("admin");
    }

    public boolean hasRealmRole(String var1);

    public boolean hasResourceRole(String var1, String var2);

    default public boolean hasResourceRoleOrIsSuperUser(String role, String resource) {
        return this.hasResourceRole(role, resource) || this.isSuperUser();
    }

    default public boolean isRealmAccessibleByUser(String realm) {
        return realm != null && realm.length() > 0 && (realm.equals(this.getAuthenticatedRealmName()) || this.isSuperUser());
    }
}

