/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import javax.ws.rs.core.UriBuilder;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Predicate;
import org.apache.camel.ProducerTemplate;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.output.MigrateResult;
import org.hibernate.Session;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.Database;
import org.openremote.container.persistence.IntegratorProvider;
import org.openremote.container.persistence.PersistenceEventInterceptor;
import org.openremote.container.util.MapAccess;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.EntityClassProvider;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.apps.ConsoleAppConfig;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetDescriptor;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.datapoint.AssetDatapoint;
import org.openremote.model.datapoint.AssetPredictedDatapoint;
import org.openremote.model.gateway.GatewayConnection;
import org.openremote.model.notification.SentNotification;
import org.openremote.model.provisioning.ProvisioningConfig;
import org.openremote.model.provisioning.X509ProvisioningConfig;
import org.openremote.model.rules.AssetRuleset;
import org.openremote.model.rules.GlobalRuleset;
import org.openremote.model.rules.RealmRuleset;
import org.openremote.model.security.Realm;
import org.openremote.model.security.RealmRole;
import org.openremote.model.security.User;
import org.openremote.model.security.UserAttribute;
import org.openremote.model.syslog.SyslogEvent;
import org.openremote.model.util.ValueUtil;

public class PersistenceService
implements ContainerService,
Consumer<PersistenceEvent<?>> {
    public static final String PERSISTENCE_TOPIC = "seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&limitConcurrentConsumers=false&size=25000";
    public static final String HEADER_ENTITY_TYPE = PersistenceEvent.class.getSimpleName() + ".ENTITY_TYPE";
    private static final Logger LOG = Logger.getLogger(PersistenceService.class.getName());
    public static final String OR_SETUP_RUN_ON_RESTART = "OR_SETUP_RUN_ON_RESTART";
    public static final String PERSISTENCE_UNIT_NAME = "PERSISTENCE_UNIT_NAME";
    public static final String PERSISTENCE_UNIT_NAME_DEFAULT = "OpenRemotePU";
    public static final String OR_DB_VENDOR = "OR_DB_VENDOR";
    public static final String OR_DB_VENDOR_DEFAULT = Database.Product.POSTGRES.name();
    public static final String OR_DB_HOST = "OR_DB_HOST";
    public static final String OR_DB_HOST_DEFAULT = "localhost";
    public static final String OR_DB_PORT = "OR_DB_PORT";
    public static final int OR_DB_PORT_DEFAULT = 5432;
    public static final String OR_DB_NAME = "OR_DB_NAME";
    public static final String OR_DB_NAME_DEFAULT = "openremote";
    public static final String OR_DB_SCHEMA = "OR_DB_SCHEMA";
    public static final String OR_DB_SCHEMA_DEFAULT = "openremote";
    public static final String OR_DB_USER = "OR_DB_USER";
    public static final String OR_DB_USER_DEFAULT = "postgres";
    public static final String OR_DB_PASSWORD = "OR_DB_PASSWORD";
    public static final String OR_DB_PASSWORD_DEFAULT = "postgres";
    public static final String OR_DB_MIN_POOL_SIZE = "OR_DB_MIN_POOL_SIZE";
    public static final int OR_DB_MIN_POOL_SIZE_DEFAULT = 5;
    public static final String OR_DB_MAX_POOL_SIZE = "OR_DB_MAX_POOL_SIZE";
    public static final int OR_DB_MAX_POOL_SIZE_DEFAULT = 20;
    public static final String OR_DB_CONNECTION_TIMEOUT_SECONDS = "OR_DB_CONNECTION_TIMEOUT_SECONDS";
    public static final int OR_DB_CONNECTION_TIMEOUT_SECONDS_DEFAULT = 300;
    public static final int PRIORITY = -2147483548;
    protected MessageBrokerService messageBrokerService;
    protected Database database;
    protected String persistenceUnitName;
    protected Properties persistenceUnitProperties;
    protected EntityManagerFactory entityManagerFactory;
    protected Flyway flyway;
    protected boolean forceClean;
    protected Set<String> defaultSchemaLocations = new HashSet<String>();
    protected Set<String> schemas = new HashSet<String>();

    public static Predicate isPersistenceEventForEntityType(Class<?> type) {
        return exchange -> {
            Class entityType = (Class)exchange.getIn().getHeader(HEADER_ENTITY_TYPE, Class.class);
            return type.isAssignableFrom(entityType);
        };
    }

    public int getPriority() {
        return -2147483548;
    }

    public void init(Container container) throws Exception {
        this.messageBrokerService = container.hasService(MessageBrokerService.class) ? (MessageBrokerService)container.getService(MessageBrokerService.class) : null;
        String dbVendor = MapAccess.getString(container.getConfig(), OR_DB_VENDOR, OR_DB_VENDOR_DEFAULT).toUpperCase(Locale.ROOT);
        LOG.info("Preparing persistence service for database: " + dbVendor);
        try {
            this.database = Database.Product.valueOf(dbVendor);
        }
        catch (Exception e) {
            LOG.severe("Requested OR_DB_VENDOR is not supported: " + dbVendor);
            throw new UnsupportedOperationException("Requested OR_DB_VENDOR is not supported: " + dbVendor);
        }
        String dbHost = MapAccess.getString(container.getConfig(), OR_DB_HOST, OR_DB_HOST_DEFAULT);
        int dbPort = MapAccess.getInteger(container.getConfig(), OR_DB_PORT, 5432);
        String dbName = MapAccess.getString(container.getConfig(), OR_DB_NAME, "openremote");
        String dbSchema = MapAccess.getString(container.getConfig(), OR_DB_SCHEMA, "openremote");
        String dbUsername = MapAccess.getString(container.getConfig(), OR_DB_USER, "postgres");
        String dbPassword = MapAccess.getString(container.getConfig(), OR_DB_PASSWORD, "postgres");
        Object connectionUrl = "jdbc:" + this.database.getConnectorName() + "://" + dbHost + ":" + dbPort + "/" + dbName;
        connectionUrl = UriBuilder.fromUri((String)connectionUrl).replaceQueryParam("currentSchema", new Object[]{dbSchema}).build(new Object[0]).toString();
        this.persistenceUnitProperties = this.database.createProperties();
        if (this.messageBrokerService != null) {
            this.persistenceUnitProperties.put("hibernate.session_factory.session_scoped_interceptor", PersistenceEventInterceptor.class.getName());
        }
        this.persistenceUnitProperties.put("hibernate.default_schema", dbSchema);
        this.persistenceUnitProperties.put("hibernate.integrator_provider", IntegratorProvider.class.getName());
        this.persistenceUnitName = MapAccess.getString(container.getConfig(), PERSISTENCE_UNIT_NAME, PERSISTENCE_UNIT_NAME_DEFAULT);
        this.forceClean = MapAccess.getBoolean(container.getConfig(), OR_SETUP_RUN_ON_RESTART, container.isDevMode());
        this.openDatabase(container, this.database, dbUsername, dbPassword, (String)connectionUrl);
        this.prepareSchema((String)connectionUrl, dbUsername, dbPassword, dbSchema);
        ArrayList<String> entityClasses = new ArrayList<String>(50);
        entityClasses.add(Asset.class.getName());
        entityClasses.add(UserAssetLink.class.getName());
        entityClasses.add(AssetDatapoint.class.getName());
        entityClasses.add(SentNotification.class.getName());
        entityClasses.add(AssetPredictedDatapoint.class.getName());
        entityClasses.add(Realm.class.getName());
        entityClasses.add(User.class.getName());
        entityClasses.add(UserAttribute.class.getName());
        entityClasses.add(RealmRole.class.getName());
        entityClasses.add(GlobalRuleset.class.getName());
        entityClasses.add(AssetRuleset.class.getName());
        entityClasses.add(RealmRuleset.class.getName());
        entityClasses.add(SyslogEvent.class.getName());
        entityClasses.add(GatewayConnection.class.getName());
        entityClasses.add(ConsoleAppConfig.class.getName());
        entityClasses.add(ProvisioningConfig.class.getName());
        entityClasses.add(X509ProvisioningConfig.class.getName());
        entityClasses.add("org.openremote.container.persistence");
        entityClasses.add("org.openremote.container.util");
        Arrays.stream(ValueUtil.getAssetDescriptors(null)).map(AssetDescriptor::getType).filter(assetClass -> assetClass.getAnnotation(Entity.class) != null).map(Class::getName).forEach(entityClasses::add);
        ServiceLoader<EntityClassProvider> entityClassProviders = ServiceLoader.load(EntityClassProvider.class);
        entityClassProviders.forEach(entityClassProvider -> entityClassProvider.getEntityClasses().stream().filter(entityClass -> entityClass.getAnnotation(Entity.class) != null).map(Class::getName).forEach(entityClasses::add));
        this.entityManagerFactory = this.getEntityManagerFactory(this.persistenceUnitProperties, entityClasses);
    }

    protected EntityManagerFactory getEntityManagerFactory(Properties properties, List<String> classNames) {
        PersistenceUnitInfo persistenceUnitInfo = new PersistenceUnitInfo(classNames, properties);
        return new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((javax.persistence.spi.PersistenceUnitInfo)persistenceUnitInfo), null).build();
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
        if (this.database != null) {
            this.database.close();
        }
    }

    public boolean isCleanInstall() {
        return this.forceClean;
    }

    public EntityManager createEntityManager() {
        EntityManager entityManager = this.getEntityManagerFactory().createEntityManager();
        if (this.messageBrokerService != null) {
            Session session = (Session)entityManager.unwrap(Session.class);
            PersistenceEventInterceptor persistenceEventInterceptor = (PersistenceEventInterceptor)((SharedSessionContractImplementor)session).getInterceptor();
            persistenceEventInterceptor.setEventConsumer(this);
        }
        return entityManager;
    }

    public void doTransaction(Consumer<EntityManager> entityManagerConsumer) {
        this.doReturningTransaction(entityManager -> {
            entityManagerConsumer.accept((EntityManager)entityManager);
            return null;
        });
    }

    public <R> R doReturningTransaction(Function<EntityManager, R> entityManagerFunction) {
        EntityManager em = this.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            R result = entityManagerFunction.apply(em);
            tx.commit();
            R r = result;
            return r;
        }
        catch (Exception ex) {
            if (tx != null && tx.isActive()) {
                try {
                    LOG.log(Level.FINE, "Rolling back failed transaction, cause follows", ex);
                    tx.rollback();
                }
                catch (RuntimeException rbEx) {
                    LOG.log(Level.SEVERE, "Rollback of transaction failed!", rbEx);
                }
            }
            throw ex;
        }
        finally {
            em.close();
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public Set<String> getDefaultSchemaLocations() {
        return this.defaultSchemaLocations;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public void publishPersistenceEvent(PersistenceEvent.Cause cause, Object currentEntity, Object previousEntity, Field[] propertyFields) {
        switch (cause) {
            case CREATE: {
                this.publishPersistenceEvent(cause, currentEntity, null, null, null);
                break;
            }
            case DELETE: {
                this.publishPersistenceEvent(cause, previousEntity, null, null, null);
                break;
            }
            case UPDATE: {
                ArrayList propertyNames = new ArrayList(propertyFields.length);
                ArrayList currentState = new ArrayList(propertyFields.length);
                ArrayList previousState = new ArrayList(propertyFields.length);
                IntStream.range(0, propertyFields.length).forEach(i -> {
                    Object previousValue;
                    Object currentValue = ValueUtil.getObjectFieldValue((Object)currentEntity, (Field)propertyFields[i]);
                    if (!ValueUtil.objectsEquals((Object)currentValue, (Object)(previousValue = ValueUtil.getObjectFieldValue((Object)previousEntity, (Field)propertyFields[i])))) {
                        propertyNames.add(propertyFields[i].getName());
                        currentState.add(currentValue);
                        previousState.add(previousValue);
                    }
                });
                this.publishPersistenceEvent(cause, currentEntity, propertyNames.toArray(new String[0]), currentState.toArray(), previousState.toArray());
            }
        }
    }

    public void publishPersistenceEvent(PersistenceEvent.Cause cause, Object entity, String[] propertyNames, Object[] currentState, Object[] previousState) {
        PersistenceEvent persistenceEvent = new PersistenceEvent(cause, entity, propertyNames, currentState, previousState);
        if (this.messageBrokerService.getProducerTemplate() != null) {
            this.messageBrokerService.getProducerTemplate().sendBodyAndHeader(PERSISTENCE_TOPIC, ExchangePattern.InOnly, (Object)persistenceEvent, HEADER_ENTITY_TYPE, persistenceEvent.getEntity().getClass());
        }
    }

    protected void openDatabase(Container container, Database database, String username, String password, String connectionUrl) {
        int databaseMinPoolSize = MapAccess.getInteger(container.getConfig(), OR_DB_MIN_POOL_SIZE, 5);
        int databaseMaxPoolSize = MapAccess.getInteger(container.getConfig(), OR_DB_MAX_POOL_SIZE, 20);
        int connectionTimeoutSeconds = MapAccess.getInteger(container.getConfig(), OR_DB_CONNECTION_TIMEOUT_SECONDS, 300);
        LOG.info("Opening database connection: " + connectionUrl);
        database.open(this.persistenceUnitProperties, connectionUrl, username, password, connectionTimeoutSeconds, databaseMinPoolSize, databaseMaxPoolSize);
    }

    protected void prepareSchema(String connectionUrl, String databaseUsername, String databasePassword, String schemaName) {
        LOG.fine("Preparing database schema");
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(schemaName);
        this.appendSchemas(schemas);
        this.appendSchemaLocations(locations);
        this.flyway = Flyway.configure().cleanDisabled(false).dataSource(connectionUrl, databaseUsername, databasePassword).schemas(schemas.toArray(new String[0])).locations(locations.toArray(new String[0])).baselineOnMigrate(true).load();
        MigrationInfo currentMigration = this.flyway.info().current();
        if (currentMigration == null && !this.forceClean) {
            LOG.warning("DB is empty so changing forceClean to true");
            this.forceClean = true;
        }
        if (this.forceClean) {
            LOG.warning("!!! Cleaning database !!!");
            this.flyway.clean();
        } else {
            LOG.fine("Not cleaning, using existing database");
        }
        for (MigrationInfo i : this.flyway.info().pending()) {
            LOG.info("Pending task: " + i.getVersion() + ", " + i.getDescription() + ", " + i.getScript());
        }
        MigrateResult result = this.flyway.migrate();
        LOG.info("Applied database schema migrations: " + result.migrationsExecuted);
        this.flyway.validate();
    }

    protected void appendSchemaLocations(List<String> locations) {
        locations.addAll(this.defaultSchemaLocations);
    }

    protected void appendSchemas(List<String> schemas) {
        schemas.addAll(this.schemas);
    }

    @Override
    public void accept(PersistenceEvent<?> persistenceEvent) {
        ProducerTemplate producerTemplate = this.messageBrokerService.getProducerTemplate();
        if (producerTemplate != null) {
            producerTemplate.sendBodyAndHeader(PERSISTENCE_TOPIC, ExchangePattern.InOnly, persistenceEvent, HEADER_ENTITY_TYPE, persistenceEvent.getEntity().getClass());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{database=" + this.database + ", persistenceUnitName='" + this.persistenceUnitName + "'}";
    }

    public static class PersistenceUnitInfo
    implements javax.persistence.spi.PersistenceUnitInfo {
        List<String> managedClassNames;
        Properties properties;

        public PersistenceUnitInfo(List<String> managedClassNames, Properties properties) {
            Properties props = new Properties();
            props.put("hibernate.format_sql", "true");
            props.put("hibernate.use_sql_comments", "true");
            props.put("hibernate.archive.autodetection", "none");
            props.put("hibernate.current_session_context_class", "thread");
            props.put("hibernate.hbm2ddl.import_files_sql_extractor", "org.openremote.container.persistence.EnhancedImportSqlCommandExtractor");
            props.putAll((Map<?, ?>)properties);
            this.managedClassNames = managedClassNames;
            this.properties = props;
        }

        public String getPersistenceUnitName() {
            return PersistenceService.PERSISTENCE_UNIT_NAME_DEFAULT;
        }

        public String getPersistenceProviderClassName() {
            return "org.hibernate.jpa.HibernatePersistenceProvider";
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }

        public DataSource getJtaDataSource() {
            return null;
        }

        public DataSource getNonJtaDataSource() {
            return null;
        }

        public List<String> getMappingFileNames() {
            return null;
        }

        public List<URL> getJarFileUrls() {
            return null;
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return true;
        }

        public SharedCacheMode getSharedCacheMode() {
            return null;
        }

        public ValidationMode getValidationMode() {
            return null;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

