/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.openremote.container.persistence.Database;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.system.HealthStatusProvider;
import org.openremote.model.util.ValueUtil;

public class PersistenceHealthStatusProvider
implements HealthStatusProvider,
ContainerService {
    private static final Logger LOG = Logger.getLogger(PersistenceHealthStatusProvider.class.getName());
    public static final String NAME = "db";
    public static final String VERSION = "1.0";
    protected PersistenceService persistenceService;

    public int getPriority() {
        return 1000;
    }

    public void init(Container container) throws Exception {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public String getHealthStatusVersion() {
        return VERSION;
    }

    public Object getHealthStatus() {
        if (this.persistenceService.persistenceUnitProperties == null) {
            return null;
        }
        String poolNameStr = this.persistenceService.persistenceUnitProperties.containsKey(Database.PROPERTY_POOL_NAME) ? this.persistenceService.persistenceUnitProperties.get(Database.PROPERTY_POOL_NAME).toString() : "or-pool";
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + poolNameStr + ")");
            HikariPoolMXBean poolMBean = JMX.newMXBeanProxy(mBeanServer, poolName, HikariPoolMXBean.class);
            int idleConnections = poolMBean.getIdleConnections();
            int activeConnections = poolMBean.getActiveConnections();
            int totalConnections = poolMBean.getTotalConnections();
            int threadsWaiting = poolMBean.getThreadsAwaitingConnection();
            ObjectNode value = ValueUtil.JSON.createObjectNode();
            value.put("idleConnections", idleConnections);
            value.put("activeConnections", activeConnections);
            value.put("totalConnections", totalConnections);
            value.put("threadsWaiting", threadsWaiting);
            return value;
        }
        catch (MalformedObjectNameException e) {
            LOG.log(Level.SEVERE, "Failed to get hikari connection pool status", e);
            return null;
        }
    }
}

