/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.apache.camel.CamelExecutionException;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.openremote.model.PersistenceEvent;

public class PersistenceEventInterceptor
extends EmptyInterceptor {
    private static final Logger LOG = Logger.getLogger(PersistenceEventInterceptor.class.getName());
    protected Consumer<PersistenceEvent<?>> eventConsumer;
    protected Set<PersistenceEvent<?>> persistenceEvents = new HashSet();

    public void setEventConsumer(Consumer<PersistenceEvent<?>> eventConsumer) {
        this.eventConsumer = eventConsumer;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        this.persistenceEvents.add(new PersistenceEvent(PersistenceEvent.Cause.CREATE, entity, propertyNames, state));
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        this.persistenceEvents.add(new PersistenceEvent(PersistenceEvent.Cause.UPDATE, entity, propertyNames, currentState, previousState));
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.persistenceEvents.add(new PersistenceEvent(PersistenceEvent.Cause.DELETE, entity, propertyNames, state));
    }

    public void afterTransactionBegin(Transaction tx) {
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterCompletion(int status) {
                try {
                    if (status != 3) {
                        return;
                    }
                    if (PersistenceEventInterceptor.this.eventConsumer == null) {
                        return;
                    }
                    for (PersistenceEvent<?> persistenceEvent : PersistenceEventInterceptor.this.persistenceEvents) {
                        try {
                            PersistenceEventInterceptor.this.eventConsumer.accept(persistenceEvent);
                        }
                        catch (CamelExecutionException ex) {
                            LOG.log(Level.SEVERE, "Error dispatching: " + persistenceEvent + " - " + ex, ex);
                        }
                    }
                }
                finally {
                    PersistenceEventInterceptor.this.persistenceEvents.clear();
                }
            }
        });
    }

    public void afterTransactionCompletion(Transaction tx) {
    }
}

