/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class FlushEntityEventListener
extends DefaultFlushEntityEventListener {
    protected boolean handleInterception(FlushEntityEvent event) {
        EventSource session = event.getSession();
        boolean intercepted = this.invokeInterceptor((SessionImplementor)session, event);
        if (intercepted && event.isDirtyCheckPossible()) {
            this.dirtyCheck(event);
        }
        return intercepted;
    }

    protected boolean invokeInterceptor(SessionImplementor session, FlushEntityEvent event) {
        if (event.getDirtyProperties() == null) {
            return false;
        }
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        Object entity = event.getEntity();
        Object[] values = event.getPropertyValues();
        int[] dirtyPropertiesIndexes = event.getDirtyProperties();
        int dirtyPropertiesLength = dirtyPropertiesIndexes.length;
        String[] dirtyPropertiesNames = new String[dirtyPropertiesLength];
        Object[] dirtyPropertiesValues = new Object[dirtyPropertiesLength];
        Object[] loadedPropertiesValues = new Object[dirtyPropertiesLength];
        Type[] dirtyPropertiesTypes = new Type[dirtyPropertiesLength];
        for (int i = 0; i < dirtyPropertiesLength; ++i) {
            int dirtyPropertyIndex = dirtyPropertiesIndexes[i];
            dirtyPropertiesNames[i] = persister.getPropertyNames()[dirtyPropertyIndex];
            dirtyPropertiesValues[i] = values[dirtyPropertyIndex];
            dirtyPropertiesTypes[i] = persister.getPropertyTypes()[dirtyPropertyIndex];
            loadedPropertiesValues[i] = entry.getLoadedState()[dirtyPropertyIndex];
        }
        return session.getInterceptor().onFlushDirty(entity, entry.getId(), dirtyPropertiesValues, loadedPropertiesValues, dirtyPropertiesNames, dirtyPropertiesTypes);
    }

    @Deprecated
    protected boolean invokeInterceptor(SessionImplementor session, Object entity, EntityEntry entry, Object[] values, EntityPersister persister) {
        throw new UnsupportedOperationException("Since this method was replaced with another one it was not suppose to be invoked.");
    }
}

