/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import org.openremote.container.PostgreSQL10LTreeDialect;
import org.openremote.container.concurrent.ContainerThreadFactory;

public interface Database {
    public static final String PROPERTY_POOL_NAME = Database.class.getName() + ".POOL_NAME";

    public Properties createProperties();

    public void open(Properties var1, String var2, String var3, String var4, int var5, int var6, int var7);

    public void close();

    public String getConnectorName();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Product implements Database
    {
        POSTGRES{
            protected HikariConfig hikariConfig;
            protected HikariDataSource hikariDataSource;

            @Override
            public Properties createProperties() {
                Properties properties = new Properties();
                properties.put("hibernate.dialect", PostgreSQL10LTreeDialect.class.getName());
                return properties;
            }

            @Override
            public String getConnectorName() {
                return "postgresql";
            }

            @Override
            public void open(Properties properties, String connectionUrl, String username, String password, int connectionTimeoutSeconds, int minIdle, int maxPoolSize) {
                this.hikariConfig = new HikariConfig();
                this.hikariConfig.setRegisterMbeans(true);
                this.hikariConfig.setPoolName(properties.containsKey(PROPERTY_POOL_NAME) ? properties.get(PROPERTY_POOL_NAME).toString() : "or-pool");
                this.hikariConfig.setThreadFactory((ThreadFactory)new ContainerThreadFactory("Database Connections"));
                this.hikariConfig.setDataSourceClassName("org.postgresql.ds.PGSimpleDataSource");
                this.hikariConfig.addDataSourceProperty("url", (Object)connectionUrl);
                this.hikariConfig.setUsername(username);
                this.hikariConfig.setPassword(password);
                this.hikariConfig.setConnectionTimeout((long)(connectionTimeoutSeconds * 1000));
                this.hikariConfig.setInitializationFailTimeout((long)(connectionTimeoutSeconds * 1000));
                this.hikariConfig.setMinimumIdle(minIdle);
                this.hikariConfig.setMaximumPoolSize(maxPoolSize);
                this.hikariDataSource = new HikariDataSource(this.hikariConfig);
                properties.put("hibernate.connection.datasource", this.hikariDataSource);
            }

            @Override
            public void close() {
                if (this.hikariDataSource != null) {
                    this.hikariDataSource.close();
                }
                this.hikariConfig = null;
                this.hikariDataSource = null;
            }
        };

    }
}

