/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.persistence;

import com.vladmihalcea.hibernate.type.util.ObjectMapperJsonSerializer;
import com.vladmihalcea.hibernate.type.util.ObjectMapperWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.hibernate.internal.util.SerializationHelper;
import org.openremote.model.util.ValueUtil;

public class CustomObjectMapperJsonSerializer
extends ObjectMapperJsonSerializer {
    protected static ObjectMapperWrapper objectMapperWrapper = new ObjectMapperWrapper(ValueUtil.JSON);

    public CustomObjectMapperJsonSerializer() {
        super(objectMapperWrapper);
    }

    public <T> T clone(T object) {
        Map.Entry firstEntry;
        boolean useStandardSerialisation = false;
        if (object instanceof Collection && object.getClass().getTypeParameters().length == 0) {
            Object firstElement = ValueUtil.findFirstNonNullElement((Collection)((Collection)object));
            if (firstElement != null && !(firstElement instanceof Serializable)) {
                return (T)objectMapperWrapper.fromBytes(objectMapperWrapper.toBytes(object), object.getClass());
            }
            useStandardSerialisation = true;
        }
        if (object instanceof Map && object.getClass().getTypeParameters().length == 0 && (firstEntry = ValueUtil.findFirstNonNullEntry((Map)((Map)object))) != null) {
            Object key = firstEntry.getKey();
            Object value = firstEntry.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
                return (T)objectMapperWrapper.fromBytes(objectMapperWrapper.toBytes(object), object.getClass());
            }
            useStandardSerialisation = true;
        }
        if (useStandardSerialisation) {
            return (T)(object instanceof Serializable ? SerializationHelper.clone((Serializable)((Serializable)object)) : objectMapperWrapper.fromBytes(objectMapperWrapper.toBytes(object), object.getClass()));
        }
        return (T)super.clone(object);
    }
}

