/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.message;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.apache.camel.Component;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.component.snmp.SnmpComponent;
import org.apache.camel.impl.DefaultStreamCachingStrategy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.openremote.container.concurrent.ContainerExecutor;
import org.openremote.container.concurrent.ContainerScheduledExecutor;
import org.openremote.container.message.MessageBrokerContext;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.DefaultWebsocketComponent;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;

public class MessageBrokerService
implements ContainerService {
    public static final String MESSAGE_SESSION_ALLOWED_ORIGIN = "MESSAGE_SESSION_ALLOWED_ORIGIN";
    public static final String MESSAGE_SESSION_ALLOWED_ORIGIN_DEFAULT = null;
    private static final Logger LOG = Logger.getLogger(MessageBrokerService.class.getName());
    public static final int PRIORITY = -2147482648;
    protected ProducerTemplate producerTemplate;
    protected MessageBrokerContext context;

    public int getPriority() {
        return -2147482648;
    }

    public void init(Container container) throws Exception {
        this.context = new MessageBrokerContext();
        ExecutorServiceManager executorServiceManager = this.context.getExecutorServiceManager();
        executorServiceManager.setThreadNamePattern("#counter# #name#");
        executorServiceManager.setThreadPoolFactory(new ThreadPoolFactory(){

            public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
                return new ContainerExecutor(this.getExecutorName("MessagingPool", threadFactory), 1, Integer.MAX_VALUE, 10L, -1);
            }

            public ExecutorService newThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
                return new ContainerExecutor(this.getExecutorName("Messaging", threadFactory), (int)profile.getPoolSize(), profile.getMaxPoolSize(), profile.getKeepAliveTime(), profile.getMaxQueueSize());
            }

            public ScheduledExecutorService newScheduledThreadPool(ThreadPoolProfile profile, ThreadFactory threadFactory) {
                return new ContainerScheduledExecutor(this.getExecutorName("MessagingTasks", threadFactory), profile.getPoolSize());
            }

            protected String getExecutorName(String name, ThreadFactory threadFactory) {
                if (threadFactory instanceof CamelThreadFactory) {
                    CamelThreadFactory factory = (CamelThreadFactory)threadFactory;
                    String camelName = factory.getName();
                    camelName = camelName.contains("://") ? StringHelper.after((String)camelName, (String)"://") : camelName;
                    camelName = camelName.contains("?") ? StringHelper.before((String)camelName, (String)"?") : camelName;
                    name = (String)name + "-" + camelName;
                }
                return name;
            }
        });
        this.context.disableJMX();
        this.context.setAllowUseOriginalMessage(false);
        this.context.setUseBreadcrumb(false);
        this.context.getShutdownStrategy().setTimeout(1L);
        this.context.getShutdownStrategy().setSuppressLoggingOnTimeout(true);
        this.context.setStreamCaching(true);
        DefaultStreamCachingStrategy streamCachingStrategy = new DefaultStreamCachingStrategy();
        streamCachingStrategy.setSpoolThreshold(524288L);
        this.context.setStreamCachingStrategy((StreamCachingStrategy)streamCachingStrategy);
        this.context.setErrorHandlerBuilder((ErrorHandlerFactory)new LoggingErrorHandlerBuilder(){

            public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
                return super.createErrorHandler(routeContext, processor);
            }
        });
        this.context.getRegistry().put((Object)Container.class.getName(), (Object)container);
        String allowedOrigin = MapAccess.getString(container.getConfig(), MESSAGE_SESSION_ALLOWED_ORIGIN, MESSAGE_SESSION_ALLOWED_ORIGIN_DEFAULT);
        DefaultWebsocketComponent websocketComponent = new DefaultWebsocketComponent(container, allowedOrigin);
        this.context.addComponent("websocket", (Component)websocketComponent);
        this.context.addComponent("snmp", (Component)new SnmpComponent());
    }

    public void start(Container container) throws Exception {
        this.producerTemplate = this.context.createProducerTemplate();
        LOG.info("Starting Camel message broker");
        this.context.start();
    }

    public void stop(Container container) throws Exception {
        if (this.context != null) {
            this.context.stop();
        }
    }

    public MessageBrokerContext getContext() {
        return this.context;
    }

    public ProducerTemplate getProducerTemplate() {
        return this.producerTemplate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

