/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalLock {
    private static final Logger LOG = Logger.getLogger(GlobalLock.class.getName());
    protected static final CustomReentrantLock lock = new CustomReentrantLock();

    protected GlobalLock() {
    }

    public static int getLockTimeoutMillis() {
        return 30000;
    }

    public static void withLock(String info, Runnable runnable) {
        GlobalLock.withLockReturning(info, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R withLockReturning(String info, Supplier<R> supplier) {
        try {
            if (!lock.tryLock(info, GlobalLock.getLockTimeoutMillis(), TimeUnit.MILLISECONDS)) throw new IllegalStateException("Could not acquire lock owned by " + lock.owner() + " after waiting " + GlobalLock.getLockTimeoutMillis() + "ms: " + Thread.currentThread().getName() + " executing " + info);
            LOG.finest("+ Acquired lock (count: " + lock.getHoldCount() + "): " + info);
            try {
                R r = supplier.get();
                return r;
            }
            finally {
                LOG.finest("- Releasing lock (count: " + lock.getHoldCount() + "): " + info);
                if (!lock.isHeldByCurrentThread()) {
                    LOG.severe("Lock is held by another thread, ensure the same thread acquires and releases the lock!");
                } else {
                    lock.unlock();
                }
            }
        }
        catch (InterruptedException ex) {
            LOG.log(Level.FINEST, "Interrupted while waiting for lock: " + info);
            return null;
        }
    }

    static class CustomReentrantLock
    extends ReentrantLock {
        String info;

        public CustomReentrantLock() {
            super(true);
        }

        String owner() {
            Thread lockOwner = super.getOwner();
            if (lockOwner != null) {
                return lockOwner.getName() + " executing " + this.info;
            }
            return "Unknown executing " + this.info;
        }

        public boolean tryLock(String info, long timeout, TimeUnit unit) throws InterruptedException {
            boolean result = super.tryLock(timeout, unit);
            if (result) {
                this.info = info;
            }
            return result;
        }

        @Override
        public void unlock() {
            super.unlock();
            this.info = null;
        }
    }
}

