/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ContainerThreads {
    public static final Logger LOG = Logger.getLogger(ContainerThreads.class.getName());
    public static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.DiscardPolicy(){

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            LOG.info("Container thread pool '" + threadPoolExecutor + "' rejected execution of " + runnable.getClass());
            super.rejectedExecution(runnable, threadPoolExecutor);
        }
    };

    public static Thread startWaitingThread() {
        Thread thread = new Thread("Container Waiting"){

            @Override
            public void run() {
                try {
                    new CountDownLatch(1).await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(false);
        thread.start();
        return thread;
    }

    public static void logExceptionCause(Runnable runnable, Throwable throwable) {
        if (throwable != null) {
            Throwable cause = ContainerThreads.unwrap(throwable);
            if (cause instanceof InterruptedException) {
                return;
            }
            LOG.log(Level.WARNING, "Thread terminated unexpectedly executing: " + runnable.getClass(), throwable);
        }
    }

    public static Throwable unwrap(Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            throw new IllegalArgumentException("Cannot unwrap null throwable");
        }
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            throwable = current;
        }
        return throwable;
    }
}

