/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ContainerThreadFactory
implements ThreadFactory {
    protected static final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final String name;
    protected final ThreadGroup group;

    public ContainerThreadFactory(String name) {
        this.name = name;
        this.group = Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.name + "-" + threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

