/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openremote.container.concurrent.ContainerThreadFactory;
import org.openremote.container.concurrent.ContainerThreads;

public class ContainerExecutor
extends ThreadPoolExecutor {
    public ContainerExecutor(String name) {
        this(name, 0, Integer.MAX_VALUE, 60L, -1);
    }

    public ContainerExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveSeconds, int blockingQueueCapacity) {
        this(new ContainerThreadFactory(name), ContainerThreads.DEFAULT_REJECTED_EXECUTION_HANDLER, corePoolSize, maximumPoolSize, keepAliveSeconds, (BlockingQueue<Runnable>)((Object)(blockingQueueCapacity == -1 ? new SynchronousQueue() : new ArrayBlockingQueue(blockingQueueCapacity))));
    }

    public ContainerExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler, int corePoolSize, int maximumPoolSize, long keepAliveSeconds, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveSeconds, TimeUnit.SECONDS, workQueue, threadFactory, rejectedHandler);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        ContainerThreads.logExceptionCause(runnable, throwable);
    }
}

