/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.container;

import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openremote.container.concurrent.ContainerScheduledExecutor;
import org.openremote.container.concurrent.ContainerThreads;
import org.openremote.container.util.LogUtil;
import org.openremote.container.util.MapAccess;
import org.openremote.model.ContainerService;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;

public class Container
implements org.openremote.model.Container {
    public static final Logger LOG;
    public static ScheduledExecutorService EXECUTOR_SERVICE;
    public static final String OR_SCHEDULED_TASKS_THREADS_MAX = "OR_SCHEDULED_TASKS_THREADS_MAX";
    public static final int OR_SCHEDULED_TASKS_THREADS_MAX_DEFAULT;
    protected final Map<String, String> config = new HashMap<String, String>();
    protected final boolean devMode;
    protected Thread waitingThread;
    protected final Map<Class<? extends ContainerService>, ContainerService> services = new LinkedHashMap<Class<? extends ContainerService>, ContainerService>();

    public Container() {
        this(StreamSupport.stream(ServiceLoader.load(ContainerService.class).spliterator(), false).sorted(Comparator.comparingInt(ContainerService::getPriority)).collect(Collectors.toList()));
    }

    public Container(ContainerService ... services) {
        this(Arrays.asList(services));
    }

    public Container(Iterable<ContainerService> services) {
        this(System.getenv(), services);
    }

    public Container(Map<String, String> config, Iterable<ContainerService> services) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            if (TextUtil.isNullOrEmpty((String)entry.getValue())) continue;
            this.config.put(entry.getKey(), entry.getValue());
        }
        this.devMode = MapAccess.getBoolean(this.config, "OR_DEV_MODE", true);
        if (this.devMode) {
            ValueUtil.JSON.enable(SerializationFeature.INDENT_OUTPUT);
        }
        int scheduledTasksThreadsMax = MapAccess.getInteger(this.getConfig(), OR_SCHEDULED_TASKS_THREADS_MAX, OR_SCHEDULED_TASKS_THREADS_MAX_DEFAULT);
        EXECUTOR_SERVICE = new NoShutdownScheduledExecutorService("Scheduled task", scheduledTasksThreadsMax);
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof ContainerService)) continue;
            ContainerService containerServiceLogHandler = (ContainerService)handler;
            this.services.put(containerServiceLogHandler.getClass(), containerServiceLogHandler);
        }
        if (services != null) {
            services.forEach(svc -> this.services.put((Class<? extends ContainerService>)svc.getClass(), (ContainerService)svc));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public boolean isRunning() {
        return this.waitingThread != null;
    }

    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            return;
        }
        LOG.info(">>> Starting runtime container...");
        try {
            for (ContainerService service : this.getServices()) {
                LOG.fine("Initializing service: " + service);
                service.init((org.openremote.model.Container)this);
            }
            for (ContainerService service : this.getServices()) {
                LOG.fine("Starting service: " + service);
                service.start((org.openremote.model.Container)this);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, ">>> Runtime container startup failed", ex);
            throw ex;
        }
        LOG.info(">>> Runtime container startup complete");
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        LOG.info("<<< Stopping runtime container...");
        List<ContainerService> servicesToStop = Arrays.asList(this.getServices());
        Collections.reverse(servicesToStop);
        try {
            for (ContainerService service : servicesToStop) {
                LOG.fine("Stopping service: " + service);
                service.stop((org.openremote.model.Container)this);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            LOG.info("Cancelling scheduled tasks");
            ((NoShutdownScheduledExecutorService)EXECUTOR_SERVICE).doShutdownNow();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception thrown whilst trying to stop scheduled tasks", e);
        }
        this.waitingThread.interrupt();
        this.waitingThread = null;
        LOG.info("<<< Runtime container stopped");
    }

    public void startBackground() throws Exception {
        this.start();
        this.waitingThread = ContainerThreads.startWaitingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerService[] getServices() {
        Map<Class<? extends ContainerService>, ContainerService> map = this.services;
        synchronized (map) {
            return this.services.values().toArray(new ContainerService[this.services.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ContainerService> Collection<T> getServices(Class<T> type) {
        Map<Class<? extends ContainerService>, ContainerService> map = this.services;
        synchronized (map) {
            HashSet<ContainerService> result = new HashSet<ContainerService>();
            for (ContainerService containerService : this.services.values()) {
                if (!type.isAssignableFrom(containerService.getClass())) continue;
                result.add(containerService);
            }
            return result;
        }
    }

    public <T extends ContainerService> boolean hasService(Class<T> type) {
        return this.getServices(type).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ContainerService> T getService(Class<T> type) throws IllegalStateException {
        Map<Class<? extends ContainerService>, ContainerService> map = this.services;
        synchronized (map) {
            ContainerService service = this.services.get(type);
            if (service == null) {
                for (ContainerService containerService : this.services.values()) {
                    if (!type.isAssignableFrom(containerService.getClass())) continue;
                    service = containerService;
                    break;
                }
            }
            if (service == null) {
                throw new IllegalStateException("Missing required service: " + type);
            }
            return (T)service;
        }
    }

    public ScheduledExecutorService getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    static {
        OR_SCHEDULED_TASKS_THREADS_MAX_DEFAULT = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        LogUtil.configureLogging();
        LOG = Logger.getLogger(Container.class.getName());
    }

    protected static class NoShutdownScheduledExecutorService
    extends ContainerScheduledExecutor {
        public NoShutdownScheduledExecutorService(String name, int corePoolSize) {
            super(name, corePoolSize);
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        void doShutdownNow() {
            super.shutdownNow();
        }
    }
}

